/*
 * Decompiled with CFR 0.152.
 */
package cn.flyelf.cache.sample.controller;

import cn.flyelf.cache.core.model.CacheTestModel;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cache/counter"})
public class CacheCounterController {
    private static final Logger log = LoggerFactory.getLogger(CacheCounterController.class);
    private final RedissonClient redisson;
    private final RedisTemplate<String, Object> redisTemplate;

    @GetMapping(value={"/next/{key}"})
    public long getNextCounter(@PathVariable(value="key") String key) {
        String redisKey = "support:counter:sample:" + key;
        RAtomicLong atomic = this.redisson.getAtomicLong(redisKey);
        return atomic.getAndIncrement();
    }

    @GetMapping(value={"/tpl/put"})
    public void putNull() {
        String redisKey = "redis:tpl:obj";
        this.redisTemplate.opsForValue().set((Object)redisKey, null);
    }

    @GetMapping(value={"/tpl/get"})
    public CacheTestModel getObj() {
        String redisKey = "redis:tpl:obj";
        return (CacheTestModel)this.redisTemplate.opsForValue().get((Object)redisKey);
    }

    public CacheCounterController(RedissonClient redisson, RedisTemplate<String, Object> redisTemplate) {
        this.redisson = redisson;
        this.redisTemplate = redisTemplate;
    }
}

