/*
 * Decompiled with CFR 0.152.
 */
package cn.flyelf.cache.sample.advice;

import cn.flyelf.cache.sample.advice.DateConverter;
import cn.flyelf.cache.sample.model.OutputDTO;
import cn.flyelf.cache.sample.model.OutputListDTO;
import java.util.List;
import javax.annotation.Nonnull;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class CustomResponseAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(CustomResponseAdvice.class);
    private static final DateConverter DATE_CONVERTER = new DateConverter();
    private static final String METHOD_CONTROLLER = "Controller";
    private static final String SPRING_PREFIX = "org.springframework.";
    private static final String SWAGGER_PREFIX = "springfox.documentation.";
    @Value(value="${spring.rest.advice.output.regex:#null}")
    private String[] customRegs;
    @Value(value="${spring.rest.advice.output.controller:true}")
    private boolean matchController;
    @Value(value="${spring.rest.advice.output.success:0}")
    private int successCode;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        GenericConversionService genericConversionService = (GenericConversionService)binder.getConversionService();
        if (genericConversionService != null) {
            genericConversionService.addConverter((Converter)DATE_CONVERTER);
        }
    }

    public boolean supports(MethodParameter returnType, @Nonnull Class<? extends HttpMessageConverter<?>> converterType) {
        String className = returnType.getExecutable().getDeclaringClass().getName();
        if (className.startsWith(SPRING_PREFIX) || className.startsWith(SWAGGER_PREFIX)) {
            return false;
        }
        if (this.matchController && className.endsWith(METHOD_CONTROLLER)) {
            return true;
        }
        if (this.customRegs == null || this.customRegs.length == 0) {
            return false;
        }
        for (String reg : this.customRegs) {
            if (!className.matches(reg)) continue;
            return true;
        }
        return false;
    }

    public Object beforeBodyWrite(Object body, @Nonnull MethodParameter returnType, @Nonnull MediaType selectedContentType, @Nonnull Class<? extends HttpMessageConverter<?>> selectedConverterType, @Nonnull ServerHttpRequest request, @Nonnull ServerHttpResponse response) {
        Object result = body;
        if (!(body instanceof OutputDTO)) {
            if (body instanceof List) {
                result = OutputListDTO.of(this.successCode, (List)((Object)body));
            } else {
                result = OutputDTO.ok(this.successCode, body);
                Class clz = returnType.getParameterType();
                if (String.class.isAssignableFrom(clz)) {
                    result = new JSONObject(result).toString();
                }
            }
        }
        log.info("result body: {}", result);
        return result;
    }
}

