package cn.flyelf.cache.sample.util;

import cn.flyelf.cache.core.Cache;
import cn.flyelf.cache.core.model.CacheTestModel;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * 模型辅助工具
 *
 * @author wujr
 * 2020/3/22
 * @version 1.0
 * 变更历史
 * [wujr 2020/3/22 1.0 新增]
 */
public class ModelUtil {
    private ModelUtil(){}

    public static CacheTestModel buildModel(int i, long[] id, String[] name, Integer[] index){
        long modelId = id[i];
        String modelName;
        if (i < name.length){
            modelName = name[i];
        }else{
            modelName = "匿名" + i;
        }
        Integer modelIndex = null;
        if (i < index.length){
            modelIndex = index[i];
        }

        return buildModel(modelId, modelName, modelIndex);
    }
    public static CacheTestModel buildModel(long id, String name, Integer index){
        CacheTestModel model = new CacheTestModel();
        model.setId(id);
        model.setName(name);
        model.setIndex(index);
        model.setDate(new Date());
        return model;
    }

    @SuppressWarnings("unchecked")
    public static Flux<CacheTestModel> putCollection(Cache cache,
                                               Collection<CacheTestModel> records,
                                               String key, long[] id, String[] name, Integer[] index,
                                                     Long duration){
        for (int i = 0; i < id.length; ++ i){
            CacheTestModel model = ModelUtil.buildModel(i, id, name, index);

            records.add(model);
        }

        Mono<Boolean> result = cache.put(key, records, duration, TimeUnit.SECONDS);
        return result.flatMapIterable(r -> records);
    }
}
