package cn.flyelf.cache.sample.controller;

import cn.flyelf.cache.annotation.CacheBean;
import cn.flyelf.cache.annotation.CacheConstant;
import cn.flyelf.cache.core.SetCache;
import cn.flyelf.cache.core.model.CacheTestModel;
import cn.flyelf.cache.sample.util.ModelUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

import java.util.HashSet;
import java.util.Set;

/**
 * set数据类型的缓存接口
 *
 * @author wujr
 * 2020/3/22
 * @version 1.0
 * 变更历史
 * [wujr 2020/3/22 1.0 新增]
 */
@RestController
@RequestMapping("/cache/set")
@Slf4j
@RequiredArgsConstructor
public class CacheSetController {
    @CacheBean(layer = {CacheConstant.LAYER_CAFFEINE})
    private SetCache<String, CacheTestModel> cacheSetCaffeine;
    @CacheBean
    private SetCache<String, CacheTestModel> cacheSetRedis;

    @GetMapping("/caffeine/put/{key}")
    public Flux<CacheTestModel> putCaffeineSet(@PathVariable("key") String key,
                                               @RequestParam("id") long[] id,
                                               @RequestParam("name") String[] name,
                                               @RequestParam("index") Integer[] index,
                                               @RequestParam(value = "duration", required = false) Long duration){
        return putSet(cacheSetCaffeine, key, id, name, index, duration);
    }
    private Flux<CacheTestModel> putSet(SetCache<String, CacheTestModel> cache,
                                        String key, long[] id, String[] name, Integer[] index,
                                        Long duration){
        Set<CacheTestModel> models = new HashSet<>();
        return ModelUtil.putCollection(cache, models, key, id, name, index, duration);
    }
    @GetMapping("/caffeine/get/{key}")
    public Flux<CacheTestModel> getCaffeineSet(@PathVariable("key") String key){
        log.info("缓存接口：caffeine/set/get, key = {}", key);
        Mono<Set<CacheTestModel>> result = cacheSetCaffeine.get(key);
        return result.flatMapMany(Flux::fromIterable);
    }

    @GetMapping("/redis/put/{key}")
    public Flux<CacheTestModel> putRedisSet(@PathVariable("key") String key,
                                            @RequestParam("id") long[] id,
                                            @RequestParam("name") String[] name,
                                            @RequestParam("index") Integer[] index,
                                            @RequestParam(value = "duration", required = false) Long duration){
        return putSet(cacheSetRedis, key, id, name, index, duration);
    }
    @GetMapping("/redis/get/{key}")
    public Flux<CacheTestModel> getRedisSet(@PathVariable("key") String key){
        Mono<Set<CacheTestModel>> result = cacheSetRedis.get(key);
        return result.flatMapMany(Flux::fromIterable);
    }
}
