package cn.flyelf.cache.sample.controller;

import cn.flyelf.cache.core.model.CacheTestModel;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 计数器的接口
 *
 * @author wujr
 * 2020/3/22
 * @version 1.0
 * 变更历史
 * [wujr 2020/3/22 1.0 新增]
 */
@RestController
@RequestMapping("/cache/counter")
@Slf4j
@RequiredArgsConstructor
public class CacheCounterController {
    private final RedissonClient redisson;
    private final RedisTemplate<String, Object> redisTemplate;

    @GetMapping("/next/{key}")
    public long getNextCounter(@PathVariable("key") String key){
        String redisKey = "support:counter:sample:" + key;
        RAtomicLong atomic = redisson.getAtomicLong(redisKey);
        return atomic.getAndIncrement();
    }

    @GetMapping("/tpl/put")
    public void putNull(){
        String redisKey = "redis:tpl:obj";
        redisTemplate.opsForValue().set(redisKey, null);
    }
    @GetMapping("/tpl/get")
    public CacheTestModel getObj(){
        String redisKey = "redis:tpl:obj";
        return (CacheTestModel)redisTemplate.opsForValue().get(redisKey);
    }
}
