package cn.flyelf.cache.sample.controller;

import cn.flyelf.cache.annotation.CacheBean;
import cn.flyelf.cache.annotation.CacheConstant;
import cn.flyelf.cache.core.Cache;
import cn.flyelf.cache.core.model.CacheTestModel;
import cn.flyelf.cache.sample.util.ModelUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

import java.util.ArrayList;
import java.util.List;

/**
 * 应用所有缓存层的缓存接口
 *
 * @author wujr
 * 2020/3/22
 * @version 1.0
 * 变更历史
 * [wujr 2020/3/22 1.0 新增]
 */
@RestController
@RequestMapping("/cache/both")
@Slf4j
@RequiredArgsConstructor
public class CacheBothController {
    @CacheBean(layer = {CacheConstant.LAYER_CAFFEINE,CacheConstant.LAYER_REDIS})
    private Cache<String, List<CacheTestModel>> cacheListBoth;
    @CacheBean(layer = {CacheConstant.LAYER_CAFFEINE,CacheConstant.LAYER_REDIS}, expire = {20L, 600L})
    private Cache<String, CacheTestModel> cacheSimpleBoth;

    @GetMapping("/list/put/{key}")
    public Flux<CacheTestModel> putBothList(@PathVariable("key") String key,
                                            @RequestParam("id") long[] id,
                                            @RequestParam("name") String[] name,
                                            @RequestParam("index") Integer[] index,
                                            @RequestParam(value = "duration", required = false) Long duration){
        List<CacheTestModel> models = new ArrayList<>(id.length);
        return ModelUtil.putCollection(cacheListBoth, models, key, id, name, index, duration);
    }
    @GetMapping("/list/get/{key}")
    public Flux<CacheTestModel> getBothList(@PathVariable("key") String key){
        Mono<List<CacheTestModel>> result = cacheListBoth.get(key);
        return result.flatMapMany(Flux::fromIterable);
    }

    @GetMapping("/simple/put/{key}")
    public Mono<Boolean> putBothSimple(@PathVariable("key") String key,
                                       @RequestParam("id") long id,
                                       @RequestParam("name") String name,
                                       @RequestParam("index") Integer index){
        CacheTestModel model = ModelUtil.buildModel(id, name, index);
        return cacheSimpleBoth.put(key, model);
    }
    @GetMapping("/simple/get/{key}")
    public Mono<CacheTestModel> getBothSimple(@PathVariable("key") String key){
        return cacheSimpleBoth.get(key);
    }
}
