/*
 * Decompiled with CFR 0.152.
 */
package cn.flyelf.cache.sample.controller;

import cn.flyelf.cache.annotation.CacheBean;
import cn.flyelf.cache.core.Cache;
import cn.flyelf.cache.core.HashCache;
import cn.flyelf.cache.core.ListCache;
import cn.flyelf.cache.core.SetCache;
import cn.flyelf.cache.core.model.CacheResult;
import cn.flyelf.cache.core.model.CacheTestModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/cache"})
public class CacheController {
    private static final Logger log = LoggerFactory.getLogger(CacheController.class);
    @CacheBean(layer={"caffeine"})
    private Cache<String, CacheTestModel> cacheCaffeine;
    @CacheBean
    private Cache<String, CacheTestModel> cacheRedis;
    @CacheBean(layer={"caffeine"})
    private ListCache<String, CacheTestModel> cacheListCaffeine;
    @CacheBean
    private ListCache<String, CacheTestModel> cacheListRedis;
    @CacheBean(layer={"caffeine"})
    private SetCache<String, CacheTestModel> cacheSetCaffeine;
    @CacheBean
    private SetCache<String, CacheTestModel> cacheSetRedis;
    @CacheBean(layer={"caffeine"})
    private HashCache<String, Long, CacheTestModel> cacheMapCaffeine;
    @CacheBean
    private HashCache<String, Long, CacheTestModel> cacheMapRedis;
    @CacheBean(layer={"caffeine", "redis"})
    private Cache<String, List<CacheTestModel>> cacheListBoth;

    @GetMapping(value={"/caffeine/simple/put/{key}"})
    public Mono<CacheTestModel> putSimpleCaffeine(@PathVariable(value="key") String key, @RequestParam(value="id") long id, @RequestParam(value="name") String name, @RequestParam(value="index") Integer index) {
        return this.putModel(key, this.cacheCaffeine, id, name, index);
    }

    @GetMapping(value={"/caffeine/simple/get/{key}"})
    public Mono<CacheTestModel> getSimpleCaffeine(@PathVariable(value="key") String key) {
        return this.cacheCaffeine.get((Object)key).map(CacheResult::getValue);
    }

    private Mono<CacheTestModel> putModel(String key, Cache<String, CacheTestModel> cache, long id, String name, Integer index) {
        CacheTestModel model = new CacheTestModel();
        model.setId(Long.valueOf(id));
        model.setName(name);
        model.setIndex(index);
        model.setDate(new Date());
        Mono result = cache.put((Object)key, (Object)model);
        return result.map(r -> model);
    }

    @GetMapping(value={"/redis/simple/put/{key}"})
    public Mono<CacheTestModel> putRedis(@PathVariable(value="key") String key, @RequestParam(value="id") long id, @RequestParam(value="name") String name, @RequestParam(value="index") Integer index) {
        return this.putModel(key, this.cacheRedis, id, name, index);
    }

    @GetMapping(value={"/redis/simple/get/{key}"})
    public Mono<CacheTestModel> getRedis(@PathVariable(value="key") String key) {
        return this.cacheRedis.get((Object)key).map(CacheResult::getValue);
    }

    @GetMapping(value={"/redis/simple/block/{key}"})
    public CacheTestModel blockRedis(@PathVariable(value="key") String key) {
        Mono result = this.cacheRedis.get((Object)key);
        CacheResult r = (CacheResult)result.block();
        return (CacheTestModel)r.getValue();
    }

    @GetMapping(value={"/redis/simple/load/{key}"})
    public Mono<CacheTestModel> getRedisNullAndLoad(@PathVariable(value="key") String key, @RequestParam(value="id", required=false) Long id, @RequestParam(value="name", required=false) String name, @RequestParam(value="index", required=false) Integer index) {
        CacheTestModel model = null;
        if (null != id) {
            model = new CacheTestModel();
            model.setId(id);
            model.setName(name);
            model.setIndex(index);
            model.setDate(new Date());
        }
        CacheTestModel finalModel = model;
        Mono result = this.cacheRedis.get((Object)key, k -> finalModel);
        return result.map(CacheResult::getValue);
    }

    @GetMapping(value={"/caffeine/list/put/{key}"})
    public Flux<CacheTestModel> putCaffeineList(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index) {
        return this.putList(this.cacheListCaffeine, key, id, name, index);
    }

    private Flux<CacheTestModel> putList(ListCache<String, CacheTestModel> cache, String key, long[] id, String[] name, Integer[] index) {
        ArrayList<CacheTestModel> models = new ArrayList<CacheTestModel>();
        return this.putCollection((Cache)cache, (Collection<CacheTestModel>)models, key, id, name, index);
    }

    @GetMapping(value={"/caffeine/list/get/{key}"})
    public Flux<CacheTestModel> getCaffeineList(@PathVariable(value="key") String key) {
        Mono result = this.cacheListCaffeine.get((Object)key);
        return result.flatMapIterable(CacheResult::getValue);
    }

    @GetMapping(value={"/redis/list/put/{key}"})
    public Flux<CacheTestModel> putRedisList(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index) {
        return this.putList(this.cacheListRedis, key, id, name, index);
    }

    @GetMapping(value={"/redis/list/get/{key}"})
    public Flux<CacheTestModel> getRedisList(@PathVariable(value="key") String key) {
        Mono result = this.cacheListRedis.get((Object)key);
        return result.flatMapIterable(CacheResult::getValue);
    }

    private Flux<CacheTestModel> putCollection(Cache cache, Collection<CacheTestModel> records, String key, long[] id, String[] name, Integer[] index) {
        for (int i = 0; i < id.length; ++i) {
            CacheTestModel model = this.buildModel(i, id, name, index);
            records.add(model);
        }
        Mono result = cache.put((Object)key, records);
        return result.flatMapIterable(r -> records);
    }

    @GetMapping(value={"/caffeine/set/put/{key}"})
    public Flux<CacheTestModel> putCaffeineSet(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index) {
        return this.putSet(this.cacheSetCaffeine, key, id, name, index);
    }

    private Flux<CacheTestModel> putSet(SetCache<String, CacheTestModel> cache, String key, long[] id, String[] name, Integer[] index) {
        HashSet<CacheTestModel> models = new HashSet<CacheTestModel>();
        return this.putCollection((Cache)cache, (Collection<CacheTestModel>)models, key, id, name, index);
    }

    @GetMapping(value={"/caffeine/set/get/{key}"})
    public Flux<CacheTestModel> getCaffeineSet(@PathVariable(value="key") String key) {
        log.info("\u7f13\u5b58\u63a5\u53e3\uff1acaffeine/set/get, key = {}", (Object)key);
        Mono result = this.cacheSetCaffeine.get((Object)key);
        return result.flatMapIterable(CacheResult::getValue);
    }

    @GetMapping(value={"/redis/set/put/{key}"})
    public Flux<CacheTestModel> putRedisSet(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index) {
        return this.putSet(this.cacheSetRedis, key, id, name, index);
    }

    @GetMapping(value={"/redis/set/get/{key}"})
    public Flux<CacheTestModel> getRedisSet(@PathVariable(value="key") String key) {
        Mono result = this.cacheSetRedis.get((Object)key);
        return result.flatMapIterable(CacheResult::getValue);
    }

    CacheTestModel buildModel(int i, long[] id, String[] name, Integer[] index) {
        CacheTestModel model = new CacheTestModel();
        model.setId(Long.valueOf(id[i]));
        if (i < name.length) {
            model.setName(name[i]);
        } else {
            model.setName("\u533f\u540d" + i);
        }
        if (i < index.length) {
            model.setIndex(index[i]);
        }
        model.setDate(new Date());
        return model;
    }

    private Flux<CacheTestModel> putMap(HashCache<String, Long, CacheTestModel> cache, String key, long[] id, String[] name, Integer[] index) {
        HashMap<Long, CacheTestModel> models = new HashMap<Long, CacheTestModel>(id.length);
        for (int i = 0; i < id.length; ++i) {
            CacheTestModel model = this.buildModel(i, id, name, index);
            models.put(model.getId(), model);
        }
        return cache.put((Object)key, models).flatMapIterable(r -> models.values());
    }

    @GetMapping(value={"/caffeine/map/put/{key}"})
    public Flux<CacheTestModel> putCaffeineHash(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index) {
        return this.putMap(this.cacheMapCaffeine, key, id, name, index);
    }

    @GetMapping(value={"/caffeine/map/get/{key}"})
    public Flux<CacheTestModel> getCaffeineHash(@PathVariable(value="key") String key) {
        return this.cacheMapCaffeine.get((Object)key).flatMapIterable(r -> ((Map)r.getValue()).values());
    }

    @GetMapping(value={"/redis/map/put/{key}"})
    public Flux<CacheTestModel> putRedisHash(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index) {
        return this.putMap(this.cacheMapRedis, key, id, name, index);
    }

    @GetMapping(value={"/redis/map/get/{key}"})
    public Flux<CacheTestModel> getRedisHash(@PathVariable(value="key") String key) {
        return this.cacheMapRedis.get((Object)key).flatMapIterable(r -> ((Map)r.getValue()).values());
    }

    @GetMapping(value={"/both/list/put/{key}"})
    public Flux<CacheTestModel> putBothList(@PathVariable(value="key") String key, @RequestParam(value="id") long[] id, @RequestParam(value="name") String[] name, @RequestParam(value="index") Integer[] index) {
        ArrayList<CacheTestModel> models = new ArrayList<CacheTestModel>(id.length);
        return this.putCollection(this.cacheListBoth, models, key, id, name, index);
    }

    @GetMapping(value={"/both/list/get/{key}"})
    public Flux<CacheTestModel> getBothList(@PathVariable(value="key") String key) {
        Mono result = this.cacheListBoth.get((Object)key);
        return result.flatMapIterable(CacheResult::getValue);
    }
}

