/*
 * Decompiled with CFR 0.152.
 */
package cn.flyelf.cache.sample.advice;

import cn.flyelf.cache.core.exception.CacheNotExistException;
import cn.flyelf.cache.sample.advice.ExceptionConfiguration;
import cn.flyelf.cache.sample.model.ExceptionClass;
import cn.flyelf.cache.sample.model.OutputDTO;
import java.util.List;
import org.joor.Reflect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAdvice.class);
    private final ExceptionConfiguration configuration;

    public ExceptionAdvice(ExceptionConfiguration configuration) {
        this.configuration = configuration;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void methodNotSupport(HttpRequestMethodNotSupportedException e) {
        log.error("\u8bf7\u6c42\u63a5\u53e3\uff1a{} \u6ca1\u6709\u627e\u5230", (Object)e.getMethod());
    }

    @ExceptionHandler(value={BindException.class})
    public OutputDTO<Void> argumentMissingHandle(BindException e) {
        StringBuilder sb = new StringBuilder();
        BindingResult bindingResult = e.getBindingResult();
        List fieldErrors = bindingResult.getFieldErrors();
        boolean first = true;
        for (FieldError fieldError : fieldErrors) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(fieldError.getField()).append(": ").append(fieldError.getDefaultMessage());
        }
        return OutputDTO.error(this.getCode((Exception)e), sb.toString());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public OutputDTO<Void> argumentTypeHandler(MethodArgumentNotValidException e) {
        List errors = e.getBindingResult().getFieldErrors();
        String msg = "";
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String split = ", ";
            for (FieldError error : errors) {
                sb.append(split).append(error.getDefaultMessage());
            }
            msg = sb.toString();
            if (msg.startsWith(split)) {
                msg = msg.substring(split.length());
            }
        }
        return OutputDTO.error(this.getCode((Exception)e), msg);
    }

    @ExceptionHandler(value={CacheNotExistException.class})
    public OutputDTO<Void> noCacheHandler(CacheNotExistException e) {
        return OutputDTO.error(101, "\u7f13\u5b58key\uff1a[" + e.getMessage() + "]\u4e0d\u5b58\u5728");
    }

    @ExceptionHandler(value={Exception.class})
    public OutputDTO<Void> exceptionHandle(Exception e) {
        ExceptionClass clz = this.findException(e);
        if (null != clz) {
            return OutputDTO.error(this.getCode(clz), clz.getMessage());
        }
        try {
            Reflect reflect = Reflect.on((Object)e).field(this.configuration.getCodeName());
            if (null != reflect && reflect.get() instanceof Integer) {
                return OutputDTO.error((Integer)reflect.get(), e.getMessage());
            }
        }
        catch (Exception ex) {
            log.debug("\u5f02\u5e38\u4e2d\u6ca1\u6709\u627e\u5230\u9519\u8bef\u7801\uff1a{}", (Object)this.configuration.getCodeName());
        }
        log.error("\u672a\u77e5\u5f02\u5e38\u5806\u6808\uff1a", (Throwable)e);
        return OutputDTO.error(this.configuration.getUnknownError(), null);
    }

    private ExceptionClass findException(Exception e) {
        if (null == this.configuration) {
            return null;
        }
        ExceptionClass[] classes = this.configuration.getClasses();
        if (null == classes || classes.length == 0) {
            return null;
        }
        for (ExceptionClass clz : classes) {
            if (!clz.isClass(e, this.configuration.getMaxDepth())) continue;
            return clz;
        }
        return null;
    }

    private int getCode(ExceptionClass clz) {
        if (null == clz) {
            return this.configuration.getUnknownError();
        }
        return clz.getCode();
    }

    private int getCode(Exception e) {
        return this.getCode(this.findException(e));
    }
}

