/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.toolsfinal.coder;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;

public class RSACoder {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String CHIPER_ALGORITHM = "RSA/ECB/";
    public static final int KEY_SIZE = 1024;
    public static final byte[] PUBLIC_EXPONENT = new byte[]{1, 0, 1};

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGen.initialize(1024, new SecureRandom());
            KeyPair keyPair = keyPairGen.genKeyPair();
            return keyPair;
        }
        catch (Exception e) {
            throw new RuntimeException("Error when init key pair, errmsg: " + e.getMessage(), e);
        }
    }

    private static RSAPublicKey generateRSAPublicKey(byte[] modulus, byte[] publicExponent) {
        try {
            RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(new BigInteger(1, modulus), new BigInteger(1, publicExponent));
            KeyFactory keyFac = KeyFactory.getInstance(KEY_ALGORITHM);
            return (RSAPublicKey)keyFac.generatePublic(pubKeySpec);
        }
        catch (Exception e) {
            throw new RuntimeException("Error when generate rsaPubblicKey, errmsg: " + e.getMessage(), e);
        }
    }

    private static RSAPrivateKey generateRSAPrivateKey(byte[] modulus, byte[] privateExponent) {
        try {
            KeyFactory keyFac = KeyFactory.getInstance(KEY_ALGORITHM);
            RSAPrivateKeySpec priKeySpec = new RSAPrivateKeySpec(new BigInteger(1, modulus), new BigInteger(1, privateExponent));
            return (RSAPrivateKey)keyFac.generatePrivate(priKeySpec);
        }
        catch (Exception e) {
            throw new RuntimeException("Error when generate rsaPrivateKey, errmsg: " + e.getMessage(), e);
        }
    }

    private static byte[] encrypt(Key key, byte[] data, PADDING padding) {
        try {
            Cipher cipher = Cipher.getInstance(CHIPER_ALGORITHM + (Object)((Object)(padding == null ? PADDING.NoPadding : padding)));
            cipher.init(1, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("Error when encrypt data, errmsg: " + e.getMessage(), e);
        }
    }

    public static byte[] encryptByPublicKey(byte[] publicKey, byte[] data, PADDING padding) {
        RSAPublicKey key = RSACoder.generateRSAPublicKey(publicKey, PUBLIC_EXPONENT);
        return RSACoder.encrypt(key, data, padding);
    }

    public static byte[] encryptByPrivateKey(byte[] publicKey, byte[] privateKey, byte[] data, PADDING padding) {
        RSAPrivateKey key = RSACoder.generateRSAPrivateKey(publicKey, privateKey);
        return RSACoder.encrypt(key, data, padding);
    }

    private static byte[] decrypt(Key key, byte[] data, PADDING padding) {
        try {
            Cipher cipher = Cipher.getInstance(CHIPER_ALGORITHM + (Object)((Object)(padding == null ? PADDING.NoPadding : padding)));
            cipher.init(2, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException("Error when decrypt data, errmsg: " + e.getMessage(), e);
        }
    }

    public static byte[] decryptByPublicKey(byte[] publicKey, byte[] data, PADDING padding) {
        RSAPublicKey key = RSACoder.generateRSAPublicKey(publicKey, PUBLIC_EXPONENT);
        return RSACoder.decrypt(key, data, padding);
    }

    public static byte[] decryptByPrivateKey(byte[] publicKey, byte[] privateKey, byte[] data, PADDING padding) {
        RSAPrivateKey key = RSACoder.generateRSAPrivateKey(publicKey, privateKey);
        return RSACoder.decrypt(key, data, padding);
    }

    public static enum PADDING {
        NoPadding,
        PKCS1Padding;

    }
}

