/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.toolsfinal;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.util.Base64;
import cn.finalteam.toolsfinal.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtils {
    public static byte[] bitmapToByte(Bitmap b) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        b.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)o);
        return o.toByteArray();
    }

    public static Bitmap byteToBitmap(byte[] b) {
        return b == null || b.length == 0 ? null : BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
    }

    public static String bitmapToString(Bitmap bitmap) {
        return Base64.encodeToString((byte[])BitmapUtils.bitmapToByte(bitmap), (int)0);
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        return drawable == null ? null : ((BitmapDrawable)drawable).getBitmap();
    }

    public static Drawable bitmapToDrawable(Bitmap bitmap) {
        return bitmap == null ? null : new BitmapDrawable(bitmap);
    }

    public static Bitmap scaleImageTo(Bitmap org, int newWidth, int newHeight) {
        return BitmapUtils.scaleImage(org, (float)newWidth / (float)org.getWidth(), (float)newHeight / (float)org.getHeight());
    }

    public static Bitmap scaleImage(Bitmap src, float scaleWidth, float scaleHeight) {
        if (src == null) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)src, (int)0, (int)0, (int)src.getWidth(), (int)src.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static Bitmap toRoundCorner(Bitmap bitmap) {
        int height = bitmap.getHeight();
        int width = bitmap.getHeight();
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, width, height);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(0);
        canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)(width / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static Bitmap createBitmapThumbnail(Bitmap bitmap, boolean needRecycle, int newHeight, int newWidth) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBitMap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        if (needRecycle) {
            bitmap.recycle();
        }
        return newBitMap;
    }

    public static void saveBitmap(Bitmap bitmap, File target) {
        if (target.exists()) {
            target.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(target);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveBitmap(Bitmap bitmap, int quality, File target) {
        if (target.exists()) {
            target.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(target);
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Bitmap compressBitmap(Bitmap bitmap, boolean needRecycle, long maxSize) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        int options = 100;
        while ((long)baos.toByteArray().length > maxSize) {
            baos.reset();
            bitmap.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
            options -= 10;
        }
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        Bitmap bm = BitmapFactory.decodeStream((InputStream)isBm, null, null);
        if (needRecycle) {
            bitmap.recycle();
        }
        bitmap = bm;
        return bitmap;
    }

    public static Bitmap compressBitmap(Bitmap bitmap, boolean needRecycle, int targetWidth, int targeHeight) {
        float sourceWidth = bitmap.getWidth();
        float sourceHeight = bitmap.getHeight();
        float scaleWidth = (float)targetWidth / sourceWidth;
        float scaleHeight = (float)targeHeight / sourceHeight;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap bm = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        if (needRecycle) {
            bitmap.recycle();
        }
        bitmap = bm;
        return bitmap;
    }

    public static Bitmap compressBitmap(String imageFile, boolean qualityCompress, long maxSize, int targetWidth, int targeHeight) {
        return BitmapUtils.compress(imageFile, null, false, qualityCompress, maxSize, targetWidth, targeHeight);
    }

    private static Bitmap compress(String imageFile, String targetFile, boolean isSave, boolean qualityCompress, long maxSize, int targetWidth, int targeHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
        int sourceWidth = options.outWidth;
        int sourceHeight = options.outHeight;
        options.inJustDecodeBounds = false;
        int inSampleSize = 1;
        while (sourceWidth / inSampleSize > targetWidth) {
            ++inSampleSize;
        }
        while (sourceHeight / inSampleSize > targeHeight) {
            ++inSampleSize;
        }
        if (inSampleSize <= 0) {
            inSampleSize = 1;
        }
        options.inSampleSize = inSampleSize;
        Bitmap bitmap = BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
        bitmap = BitmapUtils.compressBitmap(bitmap, false, targetWidth, targeHeight);
        if (qualityCompress) {
            bitmap = BitmapUtils.compressBitmap(bitmap, true, maxSize);
        }
        if (isSave) {
            String savePath = imageFile;
            if (!StringUtils.isEmpty(targetFile)) {
                savePath = targetFile;
            }
            BitmapUtils.saveBitmap(bitmap, new File(savePath));
        }
        return bitmap;
    }

    public static void compressImage(String imageFile, String targetFile, boolean qualityCompress, long maxSize, int targetWidth, int targeHeight) {
        Bitmap bitmap = BitmapUtils.compress(imageFile, targetFile, true, qualityCompress, maxSize, targetWidth, targeHeight);
        bitmap.recycle();
    }

    public static void compressImage(String imageFile, boolean qualityCompress, long maxSize, int targetWidth, int targeHeight) {
        BitmapUtils.compressImage(imageFile, null, qualityCompress, maxSize, targetWidth, targeHeight);
    }

    public static void compressImage(String imageFile, int targetWidth, int targeHeight) {
        BitmapUtils.compressImage(imageFile, null, false, 0L, targetWidth, targeHeight);
    }

    public static Bitmap compressBitmap(String imageFile, int targetWidth, int targeHeight) {
        return BitmapUtils.compressBitmap(imageFile, false, 0L, targetWidth, targeHeight);
    }

    public static void compressImageSmall(String imageFile, int scale) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
        int targetWidth = options.outWidth / scale;
        int targeHeight = options.outHeight / scale;
        BitmapUtils.compressImage(imageFile, targetWidth, targeHeight);
    }

    public static Bitmap compressBitmapSmall(String imageFile, int scale) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
        int targetWidth = options.outWidth / scale;
        int targeHeight = options.outHeight / scale;
        return BitmapUtils.compressBitmap(imageFile, targetWidth, targeHeight);
    }

    public static void compressImageBig(String imageFile, int scale) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
        int targetWidth = options.outWidth * scale;
        int targeHeight = options.outHeight * scale;
        BitmapUtils.compressImage(imageFile, targetWidth, targeHeight);
    }

    public static Bitmap compressBitmapBig(String imageFile, int scale) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
        int targetWidth = options.outWidth * scale;
        int targeHeight = options.outHeight * scale;
        return BitmapUtils.compressBitmap(imageFile, targetWidth, targeHeight);
    }

    public static void compressImage(String imageFile, String targetFile, boolean qualityCompress, long maxSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
        int targetWidth = options.outWidth / 2;
        int targeHeight = options.outHeight / 2;
        BitmapUtils.compressImage(imageFile, targetFile, qualityCompress, maxSize, targetWidth, targeHeight);
    }

    public static void compressImage(String imageFile, boolean qualityCompress, long maxSize) {
        BitmapUtils.compressImage(imageFile, null, qualityCompress, maxSize);
    }

    public static Bitmap compressBitmap(String imageFile, boolean qualityCompress, long maxSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
        int targetWidth = options.outWidth / 2;
        int targeHeight = options.outHeight / 2;
        return BitmapUtils.compressBitmap(imageFile, qualityCompress, maxSize, targetWidth, targeHeight);
    }

    public static void compressImage(String imageFile, long maxSize) {
        BitmapUtils.compressImage(imageFile, true, maxSize);
    }

    public static Bitmap compressBimap(String imageFile, long maxSize) {
        return BitmapUtils.compressBitmap(imageFile, true, maxSize);
    }

    public static void compressImage(String imageFile) {
        BitmapUtils.compressImage(imageFile, true, 0x100000L);
    }

    public static Bitmap compressBitmap(String imageFile) {
        return BitmapUtils.compressBitmap(imageFile, true, 0x100000L);
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, int degress, boolean needRecycle) {
        Matrix m = new Matrix();
        m.postRotate((float)degress);
        Bitmap bm = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
        if (needRecycle) {
            bitmap.recycle();
        }
        return bm;
    }

    public static final int getDegress(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }
}

