/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.loadingviewfinal;

import android.os.Build;
import android.view.View;
import android.widget.AbsListView;
import cn.finalteam.loadingviewfinal.OnRefreshListener;
import cn.finalteam.loadingviewfinal.PtrFrameLayout;

public abstract class OnDefaultRefreshListener
implements OnRefreshListener {
    public static boolean canChildScrollUp(View view) {
        if (Build.VERSION.SDK_INT < 14) {
            if (view instanceof AbsListView) {
                AbsListView absListView = (AbsListView)view;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return view.getScrollY() > 0;
        }
        return view.canScrollVertically(-1);
    }

    public static boolean checkContentCanBePulledDown(PtrFrameLayout frame, View content, View header) {
        return !OnDefaultRefreshListener.canChildScrollUp(content);
    }

    @Override
    public boolean checkCanDoRefresh(PtrFrameLayout frame, View content, View header) {
        return OnDefaultRefreshListener.checkContentCanBePulledDown(frame, content, header);
    }
}

