/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.loadingviewfinal;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.FrameLayout;
import android.widget.TextView;
import cn.finalteam.loadingviewfinal.PtrFrameLayout;
import cn.finalteam.loadingviewfinal.PtrUIHandler;
import cn.finalteam.loadingviewfinal.indicator.PtrIndicator;
import cn.finalteam.loadingviewfinal.uptr.R;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PtrClassicDefaultHeader
extends FrameLayout
implements PtrUIHandler {
    private static final String KEY_SharedPreferences = "cube_ptr_classic_last_update";
    private static SimpleDateFormat sDataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int mRotateAniTime = 150;
    private RotateAnimation mFlipAnimation;
    private RotateAnimation mReverseFlipAnimation;
    private TextView mTitleTextView;
    private View mRotateView;
    private View mProgressBar;
    private long mLastUpdateTime = -1L;
    private TextView mLastUpdateTextView;
    private String mLastUpdateTimeKey;
    private boolean mShouldShowLastUpdate;
    private LastUpdateTimeUpdater mLastUpdateTimeUpdater = new LastUpdateTimeUpdater();

    public PtrClassicDefaultHeader(Context context) {
        super(context);
        this.initViews(null);
    }

    public PtrClassicDefaultHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initViews(attrs);
    }

    public PtrClassicDefaultHeader(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initViews(attrs);
    }

    protected void initViews(AttributeSet attrs) {
        TypedArray arr = this.getContext().obtainStyledAttributes(attrs, R.styleable.PtrClassicHeader, 0, 0);
        if (arr != null) {
            this.mRotateAniTime = arr.getInt(R.styleable.PtrClassicHeader_ptr_rotate_ani_time, this.mRotateAniTime);
        }
        this.buildAnimation();
        View header = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.cube_ptr_classic_default_header, (ViewGroup)this);
        this.mRotateView = header.findViewById(R.id.ptr_classic_header_rotate_view);
        this.mTitleTextView = (TextView)header.findViewById(R.id.ptr_classic_header_rotate_view_header_title);
        this.mLastUpdateTextView = (TextView)header.findViewById(R.id.ptr_classic_header_rotate_view_header_last_update);
        this.mProgressBar = header.findViewById(R.id.ptr_classic_header_rotate_view_progressbar);
        this.resetView();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mLastUpdateTimeUpdater != null) {
            this.mLastUpdateTimeUpdater.stop();
        }
    }

    public void setRotateAniTime(int time) {
        if (time == this.mRotateAniTime || time == 0) {
            return;
        }
        this.mRotateAniTime = time;
        this.buildAnimation();
    }

    public void setLastUpdateTimeKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.mLastUpdateTimeKey = key;
    }

    public void setLastUpdateTimeRelateObject(Object object) {
        this.setLastUpdateTimeKey(object.getClass().getName());
    }

    private void buildAnimation() {
        this.mFlipAnimation = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mFlipAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mFlipAnimation.setDuration((long)this.mRotateAniTime);
        this.mFlipAnimation.setFillAfter(true);
        this.mReverseFlipAnimation = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mReverseFlipAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mReverseFlipAnimation.setDuration((long)this.mRotateAniTime);
        this.mReverseFlipAnimation.setFillAfter(true);
    }

    private void resetView() {
        this.hideRotateView();
        this.mProgressBar.setVisibility(4);
    }

    private void hideRotateView() {
        this.mRotateView.clearAnimation();
        this.mRotateView.setVisibility(4);
    }

    @Override
    public void onUIReset(PtrFrameLayout frame) {
        this.resetView();
        this.mShouldShowLastUpdate = true;
        this.tryUpdateLastUpdateTime();
    }

    @Override
    public void onUIRefreshPrepare(PtrFrameLayout frame) {
        this.mShouldShowLastUpdate = true;
        this.tryUpdateLastUpdateTime();
        this.mLastUpdateTimeUpdater.start();
        this.mProgressBar.setVisibility(4);
        this.mRotateView.setVisibility(0);
        this.mTitleTextView.setVisibility(0);
        if (frame.isPullToRefresh()) {
            this.mTitleTextView.setText((CharSequence)this.getResources().getString(R.string.cube_ptr_pull_down_to_refresh));
        } else {
            this.mTitleTextView.setText((CharSequence)this.getResources().getString(R.string.cube_ptr_pull_down));
        }
    }

    @Override
    public void onUIRefreshBegin(PtrFrameLayout frame) {
        this.mShouldShowLastUpdate = false;
        this.hideRotateView();
        this.mProgressBar.setVisibility(0);
        this.mTitleTextView.setVisibility(0);
        this.mTitleTextView.setText(R.string.cube_ptr_refreshing);
        this.tryUpdateLastUpdateTime();
        this.mLastUpdateTimeUpdater.stop();
    }

    @Override
    public void onUIRefreshComplete(PtrFrameLayout frame) {
        this.hideRotateView();
        this.mProgressBar.setVisibility(4);
        this.mTitleTextView.setVisibility(0);
        this.mTitleTextView.setText((CharSequence)this.getResources().getString(R.string.cube_ptr_refresh_complete));
        SharedPreferences sharedPreferences = this.getContext().getSharedPreferences(KEY_SharedPreferences, 0);
        if (!TextUtils.isEmpty((CharSequence)this.mLastUpdateTimeKey)) {
            this.mLastUpdateTime = new Date().getTime();
            sharedPreferences.edit().putLong(this.mLastUpdateTimeKey, this.mLastUpdateTime).commit();
        }
    }

    private void tryUpdateLastUpdateTime() {
        if (TextUtils.isEmpty((CharSequence)this.mLastUpdateTimeKey) || !this.mShouldShowLastUpdate) {
            this.mLastUpdateTextView.setVisibility(8);
        } else {
            String time = this.getLastUpdateTime();
            if (TextUtils.isEmpty((CharSequence)time)) {
                this.mLastUpdateTextView.setVisibility(8);
            } else {
                this.mLastUpdateTextView.setVisibility(0);
                this.mLastUpdateTextView.setText((CharSequence)time);
            }
        }
    }

    private String getLastUpdateTime() {
        if (this.mLastUpdateTime == -1L && !TextUtils.isEmpty((CharSequence)this.mLastUpdateTimeKey)) {
            this.mLastUpdateTime = this.getContext().getSharedPreferences(KEY_SharedPreferences, 0).getLong(this.mLastUpdateTimeKey, -1L);
        }
        if (this.mLastUpdateTime == -1L) {
            return null;
        }
        long diffTime = new Date().getTime() - this.mLastUpdateTime;
        int seconds = (int)(diffTime / 1000L);
        if (diffTime < 0L) {
            return null;
        }
        if (seconds <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getContext().getString(R.string.cube_ptr_last_update));
        if (seconds < 60) {
            sb.append(seconds + this.getContext().getString(R.string.cube_ptr_seconds_ago));
        } else {
            int minutes = seconds / 60;
            if (minutes > 60) {
                int hours = minutes / 60;
                if (hours > 24) {
                    Date date = new Date(this.mLastUpdateTime);
                    sb.append(sDataFormat.format(date));
                } else {
                    sb.append(hours + this.getContext().getString(R.string.cube_ptr_hours_ago));
                }
            } else {
                sb.append(minutes + this.getContext().getString(R.string.cube_ptr_minutes_ago));
            }
        }
        return sb.toString();
    }

    @Override
    public void onUIPositionChange(PtrFrameLayout frame, boolean isUnderTouch, byte status, PtrIndicator ptrIndicator) {
        int mOffsetToRefresh = frame.getOffsetToRefresh();
        int currentPos = ptrIndicator.getCurrentPosY();
        int lastPos = ptrIndicator.getLastPosY();
        if (currentPos < mOffsetToRefresh && lastPos >= mOffsetToRefresh) {
            if (isUnderTouch && status == 2) {
                this.crossRotateLineFromBottomUnderTouch(frame);
                if (this.mRotateView != null) {
                    this.mRotateView.clearAnimation();
                    this.mRotateView.startAnimation((Animation)this.mReverseFlipAnimation);
                }
            }
        } else if (currentPos > mOffsetToRefresh && lastPos <= mOffsetToRefresh && isUnderTouch && status == 2) {
            this.crossRotateLineFromTopUnderTouch(frame);
            if (this.mRotateView != null) {
                this.mRotateView.clearAnimation();
                this.mRotateView.startAnimation((Animation)this.mFlipAnimation);
            }
        }
    }

    private void crossRotateLineFromTopUnderTouch(PtrFrameLayout frame) {
        if (!frame.isPullToRefresh()) {
            this.mTitleTextView.setVisibility(0);
            this.mTitleTextView.setText(R.string.cube_ptr_release_to_refresh);
        }
    }

    private void crossRotateLineFromBottomUnderTouch(PtrFrameLayout frame) {
        this.mTitleTextView.setVisibility(0);
        if (frame.isPullToRefresh()) {
            this.mTitleTextView.setText((CharSequence)this.getResources().getString(R.string.cube_ptr_pull_down_to_refresh));
        } else {
            this.mTitleTextView.setText((CharSequence)this.getResources().getString(R.string.cube_ptr_pull_down));
        }
    }

    private class LastUpdateTimeUpdater
    implements Runnable {
        private boolean mRunning = false;

        private LastUpdateTimeUpdater() {
        }

        private void start() {
            if (TextUtils.isEmpty((CharSequence)PtrClassicDefaultHeader.this.mLastUpdateTimeKey)) {
                return;
            }
            this.mRunning = true;
            this.run();
        }

        private void stop() {
            this.mRunning = false;
            PtrClassicDefaultHeader.this.removeCallbacks(this);
        }

        @Override
        public void run() {
            PtrClassicDefaultHeader.this.tryUpdateLastUpdateTime();
            if (this.mRunning) {
                PtrClassicDefaultHeader.this.postDelayed(this, 1000L);
            }
        }
    }
}

