/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.loadingviewfinal;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.GridView;
import android.widget.ListView;
import android.widget.ScrollView;
import cn.finalteam.loadingviewfinal.srl.R;
import java.util.ArrayList;
import java.util.List;

public class SwipeRefreshLayoutFinal
extends SwipeRefreshLayout {
    private SwipeRefreshLayout.OnRefreshListener mOnRefreshListener;
    private Handler mHandler = new Handler();
    private List<View> mSwipeableScrollChildren = new ArrayList<View>();
    private int mTouchSlop;
    private float mPrevX;
    private boolean mDeclined;

    public SwipeRefreshLayoutFinal(Context context) {
        super(context);
        this.init(context, null);
    }

    public SwipeRefreshLayoutFinal(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwipeRefreshLayoutFinal);
        if (a.hasValue(R.styleable.SwipeRefreshLayoutFinal_refreshLoadingColor)) {
            int color = a.getColor(R.styleable.SwipeRefreshLayoutFinal_refreshLoadingColor, -16777216);
            this.setColorSchemeColors(new int[]{color});
        }
        a.recycle();
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    public void setOnRefreshListener(SwipeRefreshLayout.OnRefreshListener listener) {
        super.setOnRefreshListener(listener);
        this.mOnRefreshListener = listener;
    }

    public void autoRefresh() {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                SwipeRefreshLayoutFinal.this.setRefreshing(true);
                if (SwipeRefreshLayoutFinal.this.mOnRefreshListener != null) {
                    SwipeRefreshLayoutFinal.this.mOnRefreshListener.onRefresh();
                }
            }
        }, 200L);
    }

    public void onRefreshComplete() {
        this.setRefreshing(false);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.getViewGroup((ViewGroup)this);
    }

    public void getViewGroup(ViewGroup viewGroup) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View view = viewGroup.getChildAt(i);
            if (!(view instanceof ViewGroup)) continue;
            if (view instanceof ScrollView || view instanceof ListView || view instanceof GridView || view instanceof RecyclerView) {
                this.mSwipeableScrollChildren.add(view);
                continue;
            }
            this.getViewGroup((ViewGroup)view);
        }
    }

    public boolean canChildScrollUp() {
        for (View view : this.mSwipeableScrollChildren) {
            if (!view.isShown() || !ViewCompat.canScrollVertically((View)view, (int)-1)) continue;
            return true;
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mPrevX = MotionEvent.obtain((MotionEvent)event).getX();
                this.mDeclined = false;
                break;
            }
            case 2: {
                float eventX = event.getX();
                float xDiff = Math.abs(eventX - this.mPrevX);
                if (!this.mDeclined && !(xDiff > (float)this.mTouchSlop)) break;
                this.mDeclined = true;
                return false;
            }
        }
        return super.onInterceptTouchEvent(event);
    }
}

