/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.loadingviewfinal;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.SystemClock;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import cn.finalteam.loadingviewfinal.DefaultLoadMoreView;
import cn.finalteam.loadingviewfinal.HeaderAndFooterRecyclerViewAdapter;
import cn.finalteam.loadingviewfinal.ILoadMoreView;
import cn.finalteam.loadingviewfinal.LoadMoreMode;
import cn.finalteam.loadingviewfinal.OnLoadMoreListener;
import cn.finalteam.loadingviewfinal.OnScrollBottomListener;
import cn.finalteam.loadingviewfinal.loadingview.R;
import java.lang.reflect.Constructor;

public class RecyclerViewFinal
extends RecyclerView
implements OnScrollBottomListener {
    ILoadMoreView mLoadMoreView;
    LoadMoreMode mLoadMoreMode = LoadMoreMode.SCROLL;
    private boolean mLoadMoreLock;
    boolean mHasLoadMore;
    private boolean mHasLoadFail;
    private OnLoadMoreListener mOnLoadMoreListener;
    private View mEmptyView;
    private boolean mNoLoadMoreHideView;
    private HeaderAndFooterRecyclerViewAdapter mHeaderAndFooterRecyclerViewAdapter;
    private boolean mAddLoadMoreFooterFlag;
    private RecyclerView.AdapterDataObserver mDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            RecyclerView.Adapter adapter = RecyclerViewFinal.this.getAdapter();
            if (adapter != null && RecyclerViewFinal.this.mEmptyView != null) {
                if (adapter.getItemCount() == 0) {
                    RecyclerViewFinal.this.mEmptyView.setVisibility(0);
                    RecyclerViewFinal.this.setVisibility(8);
                } else {
                    RecyclerViewFinal.this.mEmptyView.setVisibility(8);
                    RecyclerViewFinal.this.setVisibility(0);
                }
            }
            RecyclerViewFinal.this.dispatchTouchEvent(MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)3, (float)0.0f, (float)0.0f, (int)0));
        }
    };

    public RecyclerViewFinal(Context context) {
        super(context);
        this.init(context, null);
    }

    public RecyclerViewFinal(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RecyclerViewFinal(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mHeaderAndFooterRecyclerViewAdapter = new HeaderAndFooterRecyclerViewAdapter();
        super.setAdapter((RecyclerView.Adapter)this.mHeaderAndFooterRecyclerViewAdapter);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LoadingViewFinal);
        this.mLoadMoreMode = a.hasValue(R.styleable.LoadingViewFinal_loadMoreMode) ? LoadMoreMode.mapIntToValue(a.getInt(R.styleable.LoadingViewFinal_loadMoreMode, 1)) : LoadMoreMode.SCROLL;
        this.mNoLoadMoreHideView = a.hasValue(R.styleable.LoadingViewFinal_noLoadMoreHideView) ? a.getBoolean(R.styleable.LoadingViewFinal_noLoadMoreHideView, false) : false;
        if (a.hasValue(R.styleable.LoadingViewFinal_loadMoreView)) {
            try {
                ILoadMoreView loadMoreView;
                String loadMoreViewName = a.getString(R.styleable.LoadingViewFinal_loadMoreView);
                Class<?> clazz = Class.forName(loadMoreViewName);
                Constructor<?> c = clazz.getConstructor(Context.class);
                this.mLoadMoreView = loadMoreView = (ILoadMoreView)c.newInstance(context);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mLoadMoreView = new DefaultLoadMoreView(context);
            }
        } else {
            this.mLoadMoreView = new DefaultLoadMoreView(context);
        }
        this.mLoadMoreView.getFooterView().setOnClickListener((View.OnClickListener)new OnMoreViewClickListener());
        this.setHasLoadMore(false);
        a.recycle();
        this.addOnScrollListener(new RecyclerViewOnScrollListener());
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        try {
            adapter.unregisterAdapterDataObserver(this.mDataObserver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        adapter.registerAdapterDataObserver(this.mDataObserver);
        this.mHeaderAndFooterRecyclerViewAdapter.setAdapter((RecyclerView.Adapter<RecyclerView.ViewHolder>)adapter);
    }

    @Override
    public void onScorllBootom() {
        if (this.mHasLoadMore && this.mLoadMoreMode == LoadMoreMode.SCROLL) {
            this.executeLoadMore();
        }
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
    }

    public void setLoadMoreView(ILoadMoreView loadMoreView) {
        if (this.mLoadMoreView != null) {
            try {
                this.removeFooterView(this.mLoadMoreView.getFooterView());
                this.mAddLoadMoreFooterFlag = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mLoadMoreView = loadMoreView;
        this.mLoadMoreView.getFooterView().setOnClickListener((View.OnClickListener)new OnMoreViewClickListener());
    }

    public void setLoadMoreMode(LoadMoreMode mode) {
        this.mLoadMoreMode = mode;
    }

    public void setNoLoadMoreHideView(boolean hide) {
        this.mNoLoadMoreHideView = hide;
    }

    void showNoMoreUI() {
        this.mLoadMoreLock = false;
        this.mLoadMoreView.showNoMore();
    }

    public void showFailUI() {
        this.mHasLoadFail = true;
        this.mLoadMoreLock = false;
        this.mLoadMoreView.showFail();
    }

    void showNormalUI() {
        this.mLoadMoreLock = false;
        this.mLoadMoreView.showNormal();
    }

    void showLoadingUI() {
        this.mHasLoadFail = false;
        this.mLoadMoreView.showLoading();
    }

    public void setHasLoadMore(boolean hasLoadMore) {
        this.mHasLoadMore = hasLoadMore;
        if (!this.mHasLoadMore) {
            this.showNoMoreUI();
            if (this.mNoLoadMoreHideView) {
                this.removeFooterView(this.mLoadMoreView.getFooterView());
                this.mAddLoadMoreFooterFlag = false;
            }
        } else {
            if (!this.mAddLoadMoreFooterFlag) {
                this.mAddLoadMoreFooterFlag = true;
                this.addFooterView(this.mLoadMoreView.getFooterView());
            }
            this.showNormalUI();
        }
    }

    public void setOnLoadMoreListener(OnLoadMoreListener loadMoreListener) {
        this.mOnLoadMoreListener = loadMoreListener;
    }

    public void onLoadMoreComplete() {
        if (this.mHasLoadFail) {
            this.showFailUI();
        } else if (this.mHasLoadMore) {
            this.showNormalUI();
        }
    }

    public void addFooterView(View footerView) {
        this.mHeaderAndFooterRecyclerViewAdapter.addFooterView(footerView);
    }

    public void addHeaderView(View headerView) {
        this.mHeaderAndFooterRecyclerViewAdapter.addHeaderView(headerView);
    }

    public void removeFooterView(View footerView) {
        this.mHeaderAndFooterRecyclerViewAdapter.removeFooter(footerView);
    }

    public void removeHeaderView(View headerView) {
        this.mHeaderAndFooterRecyclerViewAdapter.removeHeader(headerView);
    }

    void executeLoadMore() {
        if (!this.mLoadMoreLock && this.mHasLoadMore) {
            if (this.mOnLoadMoreListener != null) {
                this.mOnLoadMoreListener.loadMore();
            }
            this.mLoadMoreLock = true;
            this.showLoadingUI();
        }
    }

    public void setOnItemClickListener(HeaderAndFooterRecyclerViewAdapter.OnItemClickListener listener) {
        this.mHeaderAndFooterRecyclerViewAdapter.setOnItemClickListener(listener);
    }

    public void setOnItemLongClickListener(HeaderAndFooterRecyclerViewAdapter.OnItemLongClickListener listener) {
        this.mHeaderAndFooterRecyclerViewAdapter.setOnItemLongClickListener(listener);
    }

    private class RecyclerViewOnScrollListener
    extends RecyclerView.OnScrollListener {
        private int[] lastPositions;
        private int lastVisibleItemPosition;
        private int currentScrollState = 0;

        private RecyclerViewOnScrollListener() {
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (layoutManager instanceof LinearLayoutManager) {
                this.lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            } else if (layoutManager instanceof GridLayoutManager) {
                this.lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                if (this.lastPositions == null) {
                    this.lastPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                }
                staggeredGridLayoutManager.findLastVisibleItemPositions(this.lastPositions);
                this.lastVisibleItemPosition = this.findMax(this.lastPositions);
            } else {
                throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
            }
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            this.currentScrollState = newState;
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            int visibleItemCount = layoutManager.getChildCount();
            int totalItemCount = layoutManager.getItemCount();
            if (visibleItemCount > 0 && this.currentScrollState == 0 && this.lastVisibleItemPosition >= totalItemCount - 1) {
                RecyclerViewFinal.this.onScorllBootom();
            }
        }

        private int findMax(int[] lastPositions) {
            int max = lastPositions[0];
            for (int value : lastPositions) {
                if (value <= max) continue;
                max = value;
            }
            return max;
        }
    }

    class OnMoreViewClickListener
    implements View.OnClickListener {
        OnMoreViewClickListener() {
        }

        public void onClick(View view) {
            if (RecyclerViewFinal.this.mHasLoadMore) {
                RecyclerViewFinal.this.executeLoadMore();
            }
        }
    }
}

