/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.loadingviewfinal;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ExpandableListView;
import android.widget.ListAdapter;
import cn.finalteam.loadingviewfinal.DefaultLoadMoreView;
import cn.finalteam.loadingviewfinal.ILoadMoreView;
import cn.finalteam.loadingviewfinal.LoadMoreMode;
import cn.finalteam.loadingviewfinal.OnLoadMoreListener;
import cn.finalteam.loadingviewfinal.OnScrollBottomListener;
import cn.finalteam.loadingviewfinal.loadingview.R;
import java.lang.reflect.Constructor;

public class ExpandableListViewFinal
extends ExpandableListView
implements OnScrollBottomListener {
    ILoadMoreView mLoadMoreView;
    LoadMoreMode mLoadMoreMode = LoadMoreMode.SCROLL;
    private boolean mLoadMoreLock;
    boolean mHasLoadMore = true;
    private boolean mHasLoadFail;
    private OnLoadMoreListener mOnLoadMoreListener;
    private boolean mNoLoadMoreHideView;
    private boolean mAddLoadMoreFooterFlag;
    private int mLoadMoreViewBottom;
    private int mLoadMoreViewTop;
    private int mLoadMoreViewLeft;
    private int mLoadMoreViewRight;
    private boolean mHasLoadMoreViewShowState;
    private DataSetObserver mDataObserver = new DataSetObserver(){

        public void onChanged() {
            ExpandableListViewFinal.this.dispatchTouchEvent(MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)3, (float)0.0f, (float)0.0f, (int)0));
        }

        public void onInvalidated() {
        }
    };

    public ExpandableListViewFinal(Context context) {
        super(context);
        this.init(context, null);
    }

    public ExpandableListViewFinal(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ExpandableListViewFinal(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LoadingViewFinal);
        this.mLoadMoreMode = a.hasValue(R.styleable.LoadingViewFinal_loadMoreMode) ? LoadMoreMode.mapIntToValue(a.getInt(R.styleable.LoadingViewFinal_loadMoreMode, 1)) : LoadMoreMode.SCROLL;
        this.mNoLoadMoreHideView = a.hasValue(R.styleable.LoadingViewFinal_noLoadMoreHideView) ? a.getBoolean(R.styleable.LoadingViewFinal_noLoadMoreHideView, false) : false;
        if (a.hasValue(R.styleable.LoadingViewFinal_loadMoreView)) {
            try {
                ILoadMoreView loadMoreView;
                String loadMoreViewName = a.getString(R.styleable.LoadingViewFinal_loadMoreView);
                Class<?> clazz = Class.forName(loadMoreViewName);
                Constructor<?> c = clazz.getConstructor(Context.class);
                this.mLoadMoreView = loadMoreView = (ILoadMoreView)c.newInstance(context);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mLoadMoreView = new DefaultLoadMoreView(context);
            }
        } else {
            this.mLoadMoreView = new DefaultLoadMoreView(context);
        }
        this.setOnScrollListener(new ListViewOnScrollListener());
        a.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.hideLoadMoreView();
    }

    public void setAdapter(ListAdapter adapter) {
        if (!this.mAddLoadMoreFooterFlag) {
            this.mAddLoadMoreFooterFlag = true;
            this.addFooterView(this.mLoadMoreView.getFooterView());
        }
        super.setAdapter(adapter);
        if (adapter instanceof BaseAdapter) {
            try {
                adapter.unregisterDataSetObserver(this.mDataObserver);
            }
            catch (Exception exception) {
                // empty catch block
            }
            adapter.registerDataSetObserver(this.mDataObserver);
        }
    }

    @Override
    public void onScorllBootom() {
        if (this.mHasLoadMore && this.mLoadMoreMode == LoadMoreMode.SCROLL) {
            this.executeLoadMore();
        }
    }

    public void setLoadMoreView(ILoadMoreView loadMoreView) {
        this.mLoadMoreView = loadMoreView;
        this.mLoadMoreView.getFooterView().setOnClickListener((View.OnClickListener)new OnMoreViewClickListener());
    }

    public void setLoadMoreMode(LoadMoreMode mode) {
        this.mLoadMoreMode = mode;
    }

    public void setNoLoadMoreHideView(boolean hide) {
        this.mNoLoadMoreHideView = hide;
    }

    void showNoMoreUI() {
        this.mLoadMoreLock = false;
        this.mLoadMoreView.showNoMore();
    }

    public void showFailUI() {
        this.mHasLoadFail = true;
        this.mLoadMoreLock = false;
        this.mLoadMoreView.showFail();
    }

    void showNormalUI() {
        this.mLoadMoreLock = false;
        this.mLoadMoreView.showNormal();
    }

    void showLoadingUI() {
        this.mHasLoadFail = false;
        this.mLoadMoreView.showLoading();
    }

    public void setHasLoadMore(boolean hasLoadMore) {
        this.mHasLoadMore = hasLoadMore;
        if (!this.mHasLoadMore) {
            this.showNoMoreUI();
            if (this.mNoLoadMoreHideView && this.mHasLoadMoreViewShowState) {
                this.hideLoadMoreView();
            }
        } else {
            if (!this.mHasLoadMoreViewShowState) {
                this.showLoadMoreView();
            }
            this.showNormalUI();
        }
    }

    public void setOnLoadMoreListener(OnLoadMoreListener loadMoreListener) {
        this.mOnLoadMoreListener = loadMoreListener;
    }

    public void onLoadMoreComplete() {
        if (this.mHasLoadFail) {
            this.showFailUI();
        } else if (this.mHasLoadMore) {
            this.showNormalUI();
        }
    }

    void executeLoadMore() {
        if (!this.mLoadMoreLock && this.mHasLoadMore) {
            if (this.mOnLoadMoreListener != null) {
                this.mOnLoadMoreListener.loadMore();
            }
            this.mLoadMoreLock = true;
            this.showLoadingUI();
        }
    }

    private void hideLoadMoreView() {
        this.mHasLoadMoreViewShowState = false;
        this.mLoadMoreViewBottom = this.mLoadMoreView.getFooterView().getPaddingBottom();
        this.mLoadMoreViewTop = this.mLoadMoreView.getFooterView().getPaddingTop();
        this.mLoadMoreViewLeft = this.mLoadMoreView.getFooterView().getPaddingLeft();
        this.mLoadMoreViewRight = this.mLoadMoreView.getFooterView().getPaddingRight();
        this.mLoadMoreView.getFooterView().setVisibility(8);
        this.mLoadMoreView.getFooterView().setPadding(0, -this.mLoadMoreView.getFooterView().getHeight(), 0, 0);
    }

    private void showLoadMoreView() {
        this.mHasLoadMoreViewShowState = true;
        this.mLoadMoreView.getFooterView().setVisibility(0);
        this.mLoadMoreView.getFooterView().setPadding(this.mLoadMoreViewLeft, this.mLoadMoreViewTop, this.mLoadMoreViewRight, this.mLoadMoreViewBottom);
    }

    private class ListViewOnScrollListener
    implements AbsListView.OnScrollListener {
        private ListViewOnScrollListener() {
        }

        public void onScrollStateChanged(AbsListView listView, int scrollState) {
            if (scrollState == 0 && listView.getLastVisiblePosition() + 1 == listView.getCount()) {
                ExpandableListViewFinal.this.onScorllBootom();
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        }
    }

    class OnMoreViewClickListener
    implements View.OnClickListener {
        OnMoreViewClickListener() {
        }

        public void onClick(View view) {
            if (ExpandableListViewFinal.this.mHasLoadMore) {
                ExpandableListViewFinal.this.executeLoadMore();
            }
        }
    }
}

