/*
 * Decompiled with CFR 0.152.
 */
package cn.finalteam.loadingviewfinal;

import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;

public class HeaderAndFooterRecyclerViewAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int TYPE_HEADER_VIEW = Integer.MIN_VALUE;
    private static final int TYPE_FOOTER_VIEW = -2147483647;
    private RecyclerView.Adapter<RecyclerView.ViewHolder> mAdapter;
    private ArrayList<View> mHeaderViews = new ArrayList();
    private ArrayList<View> mFooterViews = new ArrayList();
    private ArrayList<Integer> mHeaderViewTypes = new ArrayList();
    private ArrayList<Integer> mFooterViewTypes = new ArrayList();
    private int mHeaderViewType;
    private OnItemClickListener mOnItemClickListener;
    private OnItemLongClickListener mOnItemLongClickListener;
    private RecyclerView.LayoutManager mLayoutManager;
    private RecyclerView.AdapterDataObserver mDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            super.onChanged();
            HeaderAndFooterRecyclerViewAdapter.this.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            super.onItemRangeChanged(positionStart, itemCount);
            HeaderAndFooterRecyclerViewAdapter.this.notifyItemRangeChanged(positionStart + HeaderAndFooterRecyclerViewAdapter.this.getHeadersCount(), itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            super.onItemRangeInserted(positionStart, itemCount);
            HeaderAndFooterRecyclerViewAdapter.this.notifyItemRangeInserted(positionStart + HeaderAndFooterRecyclerViewAdapter.this.getHeadersCount(), itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            super.onItemRangeRemoved(positionStart, itemCount);
            HeaderAndFooterRecyclerViewAdapter.this.notifyItemRangeRemoved(positionStart + HeaderAndFooterRecyclerViewAdapter.this.getHeadersCount(), itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            super.onItemRangeMoved(fromPosition, toPosition, itemCount);
            HeaderAndFooterRecyclerViewAdapter.this.notifyItemRangeChanged(fromPosition + HeaderAndFooterRecyclerViewAdapter.this.getHeadersCount(), toPosition + HeaderAndFooterRecyclerViewAdapter.this.getHeadersCount() + itemCount);
        }
    };

    public HeaderAndFooterRecyclerViewAdapter() {
    }

    public HeaderAndFooterRecyclerViewAdapter(RecyclerView.Adapter adapter) {
        this.setAdapter((RecyclerView.Adapter<RecyclerView.ViewHolder>)adapter);
    }

    public void setAdapter(RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
        if (null != adapter) {
            if (!(adapter instanceof RecyclerView.Adapter)) {
                throw new RuntimeException("A RecyclerView.Adapter is Need");
            }
            if (null != this.mAdapter) {
                this.notifyItemRangeRemoved(this.getHeadersCount(), this.mAdapter.getItemCount());
                this.mAdapter.unregisterAdapterDataObserver(this.mDataObserver);
            }
            this.mAdapter = adapter;
            this.mAdapter.registerAdapterDataObserver(this.mDataObserver);
            this.notifyItemRangeInserted(this.getHeadersCount(), this.mAdapter.getItemCount());
        }
    }

    public RecyclerView.Adapter getAdapter() {
        return this.mAdapter;
    }

    public boolean removeHeader(View v) {
        if (this.mHeaderViews.contains(v)) {
            this.mHeaderViews.remove(v);
            this.notifyDataSetChanged();
            return true;
        }
        return false;
    }

    public View getLastFooter() {
        return this.mFooterViews.get(this.mFooterViews.size() - 1);
    }

    public View getFirstHeader() {
        return this.mHeaderViews.get(0);
    }

    public boolean removeFooter(View v) {
        if (this.mFooterViews.contains(v)) {
            this.mFooterViews.remove(v);
            this.notifyDataSetChanged();
            return true;
        }
        return false;
    }

    public int getItemCount() {
        if (null != this.mAdapter) {
            return this.getHeadersCount() + this.getFootersCount() + this.mAdapter.getItemCount();
        }
        return this.getHeadersCount() + this.getFootersCount();
    }

    public long getItemId(int position) {
        int adapterCount;
        int adjustPosition;
        int headersCount = this.getHeadersCount();
        if (null != this.mFooterViews && position >= headersCount && (adjustPosition = position - headersCount) < (adapterCount = this.mAdapter.getItemCount())) {
            return this.mAdapter.getItemId(adjustPosition);
        }
        return -1L;
    }

    public int getItemViewType(int position) {
        int mHeadersCount = this.getHeadersCount();
        if (null != this.mAdapter) {
            int itemCount = this.mAdapter.getItemCount();
            if (position < mHeadersCount) {
                this.mHeaderViewType = Integer.MIN_VALUE + position;
                this.mHeaderViewTypes.add(this.mHeaderViewType);
                return this.mHeaderViewType;
            }
            if (position >= mHeadersCount && position < mHeadersCount + itemCount) {
                int itemViewType = this.mAdapter.getItemViewType(position - mHeadersCount);
                if (itemViewType <= Integer.MIN_VALUE + mHeadersCount) {
                    throw new IllegalArgumentException("your adapter's return value of getItemViewType() must > (Integer.MinValue + your headersCount)");
                }
                return itemViewType;
            }
            int mFooterViewType = -2147483647 + position - itemCount;
            this.mFooterViewTypes.add(mFooterViewType);
            return mFooterViewType;
        }
        return -2;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (null != this.mAdapter) {
            if (this.mHeaderViewTypes.contains(viewType)) {
                return new RecyclerHeaderViewHolder(this.mHeaderViews.get(viewType - Integer.MIN_VALUE));
            }
            if (this.mFooterViewTypes.contains(viewType)) {
                return new RecyclerHeaderViewHolder(this.mFooterViews.get(viewType - this.getHeadersCount() - -2147483647));
            }
            return this.mAdapter.onCreateViewHolder(parent, viewType);
        }
        return null;
    }

    public void onBindViewHolder(final RecyclerView.ViewHolder holder, final int position) {
        if (null != this.mAdapter) {
            if (position >= this.getHeadersCount() && position < this.getHeadersCount() + this.mAdapter.getItemCount()) {
                this.mAdapter.onBindViewHolder(holder, position - this.getHeadersCount());
                if (null != this.mOnItemClickListener) {
                    holder.itemView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            HeaderAndFooterRecyclerViewAdapter.this.mOnItemClickListener.onItemClick(holder, position - HeaderAndFooterRecyclerViewAdapter.this.getHeadersCount());
                        }
                    });
                }
                if (null != this.mOnItemLongClickListener) {
                    holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

                        public boolean onLongClick(View v) {
                            return HeaderAndFooterRecyclerViewAdapter.this.mOnItemLongClickListener.onItemLongCLick(holder, position - HeaderAndFooterRecyclerViewAdapter.this.getHeadersCount());
                        }
                    });
                }
            } else if (null != this.mLayoutManager && this.mLayoutManager instanceof StaggeredGridLayoutManager) {
                StaggeredGridLayoutManager.LayoutParams params = new StaggeredGridLayoutManager.LayoutParams(-1, -1);
                params.setFullSpan(true);
                holder.itemView.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
    }

    public Integer getHeadersCount() {
        if (null != this.mHeaderViews) {
            return this.mHeaderViews.size();
        }
        return 0;
    }

    public ArrayList<View> getHeaderViews() {
        return this.mHeaderViews;
    }

    public Integer getFootersCount() {
        if (null != this.mFooterViews) {
            return this.mFooterViews.size();
        }
        return 0;
    }

    public ArrayList<View> getFooterViews() {
        return this.mFooterViews;
    }

    public void addHeaderView(View v, int position) {
        if (null != v) {
            if (this.mHeaderViews.contains(v)) {
                this.mHeaderViews.remove(v);
            }
            if (position > this.mHeaderViews.size()) {
                position = this.mHeaderViews.size();
            }
            this.mHeaderViews.add(position, v);
            this.notifyDataSetChanged();
        }
    }

    public void addHeaderView(View v) {
        if (null != v) {
            if (this.mHeaderViews.contains(v)) {
                this.removeHeader(v);
            }
            this.mHeaderViews.add(v);
            this.notifyDataSetChanged();
        }
    }

    public void addFooterView(View v) {
        if (null != v) {
            if (this.mFooterViews.contains(v)) {
                this.removeFooter(v);
            }
            this.mFooterViews.add(v);
            this.notifyDataSetChanged();
        }
    }

    public boolean isHeader(int position) {
        return this.getHeadersCount() > 0 && position <= this.getHeadersCount() - 1;
    }

    public boolean isFooter(int position) {
        int lastPosition = this.getItemCount() - this.getFootersCount();
        return this.getFootersCount() > 0 && position >= lastPosition;
    }

    public void putLayoutManager(RecyclerView.LayoutManager layoutManager) {
        this.mLayoutManager = layoutManager;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.mOnItemLongClickListener = onItemLongClickListener;
    }

    public class RecyclerHeaderViewHolder
    extends RecyclerView.ViewHolder {
        public RecyclerHeaderViewHolder(View itemView) {
            super(itemView);
        }
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongCLick(RecyclerView.ViewHolder var1, int var2);
    }

    public static interface OnItemClickListener {
        public void onItemClick(RecyclerView.ViewHolder var1, int var2);
    }
}

