/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.component.sorm.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.component.sorm.mapping.PropertyMapping;
import cn.featherfly.component.sorm.operate.AbstractOperate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class MergeOperate<T>
extends AbstractOperate<T> {
    public MergeOperate(Class<T> type, JdbcTemplate jdbcTemplate) {
        super(type, jdbcTemplate);
    }

    public MergeOperate(Class<T> type, JdbcTemplate jdbcTemplate, String dataBase) {
        super(type, jdbcTemplate, dataBase);
    }

    public int execute(final T entity) {
        return (Integer)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Integer>(){

            public Integer doInConnection(Connection conn) throws SQLException, DataAccessException {
                HashMap propertyPositions = new HashMap();
                String sql = MergeOperate.this.getDynamicSql(entity, propertyPositions);
                MergeOperate.this.logger.debug("execute sql: {}", (Object)sql);
                PreparedStatement prep = conn.prepareStatement(sql);
                for (Map.Entry propertyPosition : propertyPositions.entrySet()) {
                    JdbcUtils.setParameter((PreparedStatement)prep, (int)((Integer)propertyPosition.getKey()), (Object)BeanUtils.getProperty((Object)entity, (String)((String)propertyPosition.getValue())));
                }
                int result = prep.executeUpdate();
                prep.close();
                return result;
            }
        });
    }

    private String getDynamicSql(T entity, Map<Integer, String> propertyPositions) {
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(this.classMapping.getTableName()).append(" set ");
        int columnNum = 0;
        for (PropertyMapping pm : this.classMapping.getPropertyMappings()) {
            if (BeanUtils.getProperty(entity, (String)pm.getPropertyName()) == null) continue;
            updateSql.append(pm.getColumnName()).append(" = ? ,");
            propertyPositions.put(++columnNum, pm.getFinalPropertyName());
        }
        if (columnNum > 0) {
            updateSql.deleteCharAt(updateSql.length() - 1);
        }
        int pkNum = 0;
        updateSql.append("where ");
        for (PropertyMapping pm : this.classMapping.getPropertyMappings()) {
            if (!pm.isPrimaryKey()) continue;
            if (pkNum > 0) {
                updateSql.append("and ");
            }
            updateSql.append(pm.getColumnName()).append(" = ? ");
            propertyPositions.put(columnNum + ++pkNum, pm.getFinalPropertyName());
        }
        this.sql = updateSql.toString();
        return updateSql.toString();
    }

    @Override
    protected void initSql() {
    }
}

