/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.component.sorm.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.component.sorm.mapping.PropertyMapping;
import cn.featherfly.component.sorm.operate.AbstractOperate;
import java.sql.ResultSet;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class AbstractQueryOperate<T>
extends AbstractOperate<T> {
    private String selectSql;

    public AbstractQueryOperate(Class<T> type, JdbcTemplate jdbcTemplate) {
        super(type, jdbcTemplate);
    }

    public AbstractQueryOperate(Class<T> type, JdbcTemplate jdbcTemplate, String dataBase) {
        super(type, jdbcTemplate, dataBase);
    }

    protected T mapRow(ResultSet rs, int rowNumber) {
        Object mappedObject = BeanUtils.instantiateClass(this.classMapping.getType());
        int index = 1;
        for (PropertyMapping propertyMapping : this.classMapping.getPropertyMappings()) {
            Object value = this.getColumnValue(rs, index, propertyMapping.getFinalPropertyType());
            if (this.logger.isDebugEnabled() && rowNumber == 0) {
                this.logger.debug("Mapping column '{}' to property '{}' of type {}", new Object[]{propertyMapping.getColumnName(), propertyMapping.getFinalPropertyName(), propertyMapping.getFinalPropertyType()});
            }
            BeanUtils.setProperty((Object)mappedObject, (String)propertyMapping.getFinalPropertyName(), (Object)value);
            ++index;
        }
        return (T)mappedObject;
    }

    @Override
    protected void initSql() {
        this.initSelectSql();
        StringBuilder getSql = new StringBuilder();
        getSql.append(this.getSelectSql());
        String condition = this.initCondition();
        if (LangUtils.isNotEmpty((String)condition)) {
            getSql.append(" where ").append(condition);
        }
        this.sql = getSql.toString();
        this.logger.debug("sql: {}", (Object)this.sql);
    }

    protected abstract String initCondition();

    private Object getColumnValue(ResultSet rs, int index, Class<?> propertyType) {
        return JdbcUtils.getResultSetValue((ResultSet)rs, (int)index, propertyType);
    }

    private void initSelectSql() {
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select ");
        int columnNum = 0;
        for (PropertyMapping propertyMapping : this.classMapping.getPropertyMappings()) {
            selectSql.append(propertyMapping.getColumnName()).append(" as ").append(propertyMapping.getPropertyName()).append(",");
            ++columnNum;
        }
        if (columnNum > 0) {
            selectSql.deleteCharAt(selectSql.length() - 1);
        }
        selectSql.append(" from ").append(this.classMapping.getTableName());
        this.selectSql = selectSql.toString();
    }

    public String getSelectSql() {
        return this.selectSql;
    }
}

