/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.component.sorm.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.DatabaseMetadataManager;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.component.sorm.mapping.ClassMapping;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class AbstractOperate<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String sql;
    protected JdbcTemplate jdbcTemplate;
    protected ClassMapping<T> classMapping;
    protected DatabaseMetadata meta;
    protected Map<Integer, String> propertyPositions = new HashMap<Integer, String>(0);

    public AbstractOperate(Class<T> type, JdbcTemplate jdbcTemplate) {
        this(type, jdbcTemplate, null);
    }

    public AbstractOperate(Class<T> type, JdbcTemplate jdbcTemplate, String dataBase) {
        this.meta = LangUtils.isEmpty((String)dataBase) ? DatabaseMetadataManager.getDefaultManager().create(jdbcTemplate.getDataSource()) : DatabaseMetadataManager.getDefaultManager().create(jdbcTemplate.getDataSource(), dataBase);
        this.jdbcTemplate = jdbcTemplate;
        this.classMapping = ClassMapping.getMappedClass(type, this.meta);
        this.initSql();
    }

    public String getSql() {
        return this.sql;
    }

    protected void setParameter(PreparedStatement prep, T entity) {
        for (Map.Entry<Integer, String> propertyPosition : this.propertyPositions.entrySet()) {
            JdbcUtils.setParameter((PreparedStatement)prep, (int)propertyPosition.getKey(), (Object)BeanUtils.getProperty(entity, (String)propertyPosition.getValue()));
        }
    }

    public Object[] getParameters(T entity) {
        Object[] params = new Object[this.propertyPositions.size()];
        int i = 0;
        for (Map.Entry<Integer, String> propertyPosition : this.propertyPositions.entrySet()) {
            params[i] = BeanUtils.getProperty(entity, (String)propertyPosition.getValue());
            ++i;
        }
        return params;
    }

    protected void setParameter(PreparedStatement prep, Serializable id) {
        JdbcUtils.setParameter((PreparedStatement)prep, (int)1, (Object)id);
    }

    protected abstract void initSql();
}

