/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.component.sorm.operate;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.component.sorm.SimpleORMException;
import cn.featherfly.component.sorm.mapping.PropertyMapping;
import cn.featherfly.component.sorm.operate.AbstractOperate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class AbstractExecuteOperate<T>
extends AbstractOperate<T> {
    private boolean generatedKey;

    public AbstractExecuteOperate(Class<T> type, JdbcTemplate jdbcTemplate) {
        super(type, jdbcTemplate);
    }

    public AbstractExecuteOperate(Class<T> type, JdbcTemplate jdbcTemplate, String dataBase) {
        super(type, jdbcTemplate, dataBase);
    }

    public int execute(final T entity) {
        return (Integer)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Integer>(){

            public Integer doInConnection(Connection con) throws SQLException, DataAccessException {
                PreparedStatement prep = null;
                prep = AbstractExecuteOperate.this.generatedKey ? con.prepareStatement(AbstractExecuteOperate.this.sql, 1) : con.prepareStatement(AbstractExecuteOperate.this.sql);
                AbstractExecuteOperate.this.setParameter(prep, entity);
                AbstractExecuteOperate.this.logger.debug("execute sql: {}", (Object)AbstractExecuteOperate.this.sql);
                int result = prep.executeUpdate();
                if (AbstractExecuteOperate.this.generatedKey) {
                    PropertyMapping pm = null;
                    int i = 0;
                    for (PropertyMapping propertyMapping : AbstractExecuteOperate.this.classMapping.getPropertyMappings()) {
                        if (!propertyMapping.isPrimaryKey()) continue;
                        pm = propertyMapping;
                        ++i;
                    }
                    if (i > 1) {
                        throw new SimpleORMException("#generate.multi.pk");
                    }
                    ResultSet res = prep.getGeneratedKeys();
                    StringBuilder msg = null;
                    if (AbstractExecuteOperate.this.logger.isDebugEnabled()) {
                        msg = new StringBuilder("\u81ea\u52a8\u751f\u6210\u7684\u952e\u503c : ");
                    }
                    if (res.next()) {
                        Object value = JdbcUtils.getResultSetValue((ResultSet)res, (int)1, pm.getPropertyType());
                        if (AbstractExecuteOperate.this.logger.isDebugEnabled()) {
                            msg.append(" ").append(value).append(", ");
                        }
                        BeanUtils.setProperty((Object)entity, (String)pm.getPropertyName(), (Object)value);
                    }
                    if (AbstractExecuteOperate.this.logger.isDebugEnabled()) {
                        AbstractExecuteOperate.this.logger.debug(msg.toString());
                    }
                }
                prep.close();
                return result;
            }
        });
    }

    public boolean isGeneratedKey() {
        return this.generatedKey;
    }

    public void setGeneratedKey(boolean generatedKey) {
        this.generatedKey = generatedKey;
    }
}

