/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.component.sorm.mapping;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.matcher.BeanPropertyAnnotationMatcher;
import cn.featherfly.common.bean.matcher.BeanPropertyMatcher;
import cn.featherfly.common.bean.matcher.BeanPropertyNameRegexMatcher;
import cn.featherfly.common.db.metadata.ColumnMetadata;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.TableMetadata;
import cn.featherfly.common.enums.Logic;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.ServiceLoaderUtils;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.common.lang.SystemPropertyUtils;
import cn.featherfly.common.lang.WordUtils;
import cn.featherfly.component.sorm.SimpleORMException;
import cn.featherfly.component.sorm.annotation.Column;
import cn.featherfly.component.sorm.annotation.Identity;
import cn.featherfly.component.sorm.mapping.ClassTableNameFactory;
import cn.featherfly.component.sorm.mapping.ClassTableNameJpaFactory;
import cn.featherfly.component.sorm.mapping.ClassTableNameSormAnnotationFactory;
import cn.featherfly.component.sorm.mapping.ClassTableNameSormNameMapFactory;
import cn.featherfly.component.sorm.mapping.PropertyMapping;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassMapping<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassMapping.class);
    private static final char UNDER_LINE = '_';
    private static final Map<Class<?>, ClassMapping<?>> MAPPED_CLASS = new HashMap();
    private static final List<ClassTableNameFactory> TABLE_NAME_FACTORIES = ServiceLoaderUtils.loadAll(ClassTableNameFactory.class);
    private Map<String, PropertyMapping> propertyMappings = new HashMap<String, PropertyMapping>(0);
    private String tableName;
    private Class<?> type;

    public ClassMapping(Class<T> type, String tableName) {
        this.type = type;
        this.tableName = tableName;
    }

    public PropertyMapping getPropertyMapping(String propertyName) {
        return this.propertyMappings.get(propertyName);
    }

    public Collection<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings.values();
    }

    public static <T> ClassMapping<T> getMappedClass(Class<T> type, DatabaseMetadata meta) {
        ClassMapping<Object> cm = MAPPED_CLASS.get(type);
        if (cm == null) {
            HashMap<String, PropertyMapping> tableMapping = new HashMap<String, PropertyMapping>();
            StringBuilder logInfo = new StringBuilder();
            BeanDescriptor bd = BeanDescriptor.getBeanDescriptor(type);
            String tableName = ClassMapping.getTableName(type);
            tableName = tableName.toUpperCase();
            logInfo.append(String.format("###%s\u7c7b%s\u6620\u5c04\u5230\u8868%s", SystemPropertyUtils.getLineSeparator(), type.getName(), tableName));
            Collection bps = bd.findBeanPropertys((BeanPropertyMatcher)new BeanPropertyAnnotationMatcher(Logic.OR, new Class[]{Column.class, Identity.class, Id.class}));
            boolean findPk = false;
            for (BeanProperty beanProperty : bps) {
                if (!ClassMapping.mapping(beanProperty, tableMapping, logInfo)) continue;
                findPk = true;
            }
            if (!findPk) {
                throw new SimpleORMException("#id.map.not.exists", new Object[]{type.getName()});
            }
            TableMetadata tm = meta.getTable(tableName);
            if (tm == null) {
                throw new SimpleORMException("#talbe.not.exists", new Object[]{tableName});
            }
            for (ColumnMetadata cmd : tm.getColumns()) {
                ClassMapping.mappingHidden(bd, tableMapping, cmd, logInfo);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(logInfo.toString());
            }
            cm = new ClassMapping<T>(type, tableName);
            super.addPropertyMappings(tableMapping.values());
            MAPPED_CLASS.put(type, cm);
        }
        return cm;
    }

    private static String getTableName(Class<?> type) {
        String tableName = null;
        for (ClassTableNameFactory classTableNameFactory : TABLE_NAME_FACTORIES) {
            tableName = classTableNameFactory.getMappingTableName(type);
            if (!LangUtils.isNotEmpty((String)tableName)) continue;
            return tableName;
        }
        if (LangUtils.isEmpty(tableName)) {
            throw new SimpleORMException("#notalbe.map.type", new Object[]{type.getName()});
        }
        return tableName;
    }

    private static boolean mapping(BeanProperty<?> beanProperty, Map<String, PropertyMapping> tableMapping, StringBuilder logInfo) {
        boolean hasPk;
        PropertyMapping mapping = new PropertyMapping();
        Column columnAnnotation = (Column)beanProperty.getAnnotation(Column.class);
        String columnName = null;
        String innerProperty = null;
        if (columnAnnotation == null) {
            columnName = WordUtils.addSignBeforeUpper((String)beanProperty.getName(), (char)'_', (boolean)true);
        } else {
            columnName = columnAnnotation.value();
            innerProperty = columnAnnotation.innerProperty();
        }
        mapping.setColumnName(columnName.toUpperCase());
        mapping.setPropertyName(beanProperty.getName());
        mapping.setPropertyType(beanProperty.getType());
        if (StringUtils.isNotEmpty((String)innerProperty)) {
            BeanDescriptor innerBd = BeanDescriptor.getBeanDescriptor((Class)beanProperty.getType());
            BeanProperty innerBeanProperty = innerBd.getBeanProperty(innerProperty);
            mapping.setInnerPropertyName(innerBeanProperty.getName());
            mapping.setInnerPropertyType(innerBeanProperty.getType());
        }
        if (!(hasPk = beanProperty.hasAnnotation(Identity.class))) {
            hasPk = beanProperty.hasAnnotation(Id.class);
        }
        mapping.setPrimaryKey(hasPk);
        tableMapping.put(mapping.getColumnName(), mapping);
        if (LOGGER.isDebugEnabled()) {
            logInfo.append(String.format("%s###\t%s -> %s", SystemPropertyUtils.getLineSeparator(), mapping.getFinalPropertyName(), mapping.getColumnName()));
        }
        return hasPk;
    }

    private static <T> void mappingHidden(BeanDescriptor<T> bd, Map<String, PropertyMapping> tableMapping, ColumnMetadata cmd, StringBuilder logInfo) {
        if (!tableMapping.containsKey(cmd.getName())) {
            String columnName = cmd.getName().toLowerCase();
            String propertyName = WordUtils.parseToUpperFirst((String)columnName, (char)"_".charAt(0));
            BeanProperty beanProperty = bd.findBeanProperty((BeanPropertyMatcher)new BeanPropertyNameRegexMatcher(propertyName));
            if (beanProperty != null) {
                PropertyMapping mapping = new PropertyMapping();
                mapping.setPropertyType(beanProperty.getType());
                mapping.setPropertyName(propertyName);
                mapping.setColumnName(columnName.toUpperCase());
                mapping.setPrimaryKey(cmd.isPrimaryKey());
                tableMapping.put(mapping.getColumnName(), mapping);
                if (LOGGER.isDebugEnabled()) {
                    logInfo.append(String.format("%s###\t%s -> %s", SystemPropertyUtils.getLineSeparator(), mapping.getPropertyName(), mapping.getColumnName()));
                }
            } else if (LOGGER.isDebugEnabled()) {
                logInfo.append(String.format("%s\t\u6ca1\u6709\u5c5e\u6027 -> %s [\u5217%s\u7684\u9690\u5f0f\u6620\u5c04]", SystemPropertyUtils.getLineSeparator(), propertyName, cmd.getName()));
            }
        }
    }

    private void addPropertyMapping(PropertyMapping propertyMapping) {
        this.propertyMappings.put(propertyMapping.getPropertyName(), propertyMapping);
    }

    private void addPropertyMappings(Collection<PropertyMapping> propertyMappings) {
        for (PropertyMapping propertyMapping : propertyMappings) {
            this.addPropertyMapping(propertyMapping);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public Class<?> getType() {
        return this.type;
    }

    static {
        TABLE_NAME_FACTORIES.add(new ClassTableNameJpaFactory());
        TABLE_NAME_FACTORIES.add(new ClassTableNameSormAnnotationFactory());
        TABLE_NAME_FACTORIES.add(new ClassTableNameSormNameMapFactory());
    }
}

