/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.component.sorm;

import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.component.sorm.SimpleORM;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class SimpleORMFactory {
    private static final SimpleORMFactory INSTANCE = new SimpleORMFactory(null);
    private final Map<Class<?>, SimpleORM<?>> cache = new HashMap(0);
    private DataSource dataSource;
    private String dataBase;

    public SimpleORMFactory() {
    }

    public SimpleORMFactory(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public SimpleORMFactory(DataSource dataSource, String dataBase) {
        this.dataSource = dataSource;
        this.dataBase = dataBase;
    }

    public static SimpleORMFactory getDefaultFactory() {
        return INSTANCE;
    }

    public static SimpleORMFactory getDefaultFactory(DataSource dataSource) {
        INSTANCE.setDataSource(dataSource);
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> SimpleORM<E> getSimpleORM(Class<E> type) {
        AssertIllegalArgument.isNotNull((Object)this.dataSource, (String)"\u8bf7\u5148\u4f7f\u7528setDataSource\u4e3aSimpleORMFactory\u8bbe\u7f6e\u6570\u636e\u6e90");
        if (LangUtils.isEmpty((String)this.dataBase)) {
            this.dataBase = JdbcUtils.getCatalog((DataSource)this.dataSource);
        }
        AssertIllegalArgument.isNotEmpty((String)this.dataBase, (String)"\u8bf7\u5148\u4f7f\u7528setDataBase\u4e3aSimpleORMFactory\u8bbe\u7f6e\u5177\u4f53\u6570\u636e\u5e93\uff08mysql\u4e3a\u6570\u636e\u5e93\uff0coracle\u4e3a\u8868\u7a7a\u95f4\uff09");
        SimpleORM<Object> simpleORM = this.cache.get(type);
        if (simpleORM == null) {
            Map<Class<?>, SimpleORM<?>> map = this.cache;
            synchronized (map) {
                if (simpleORM == null) {
                    simpleORM = new SimpleORM<E>(type, new JdbcTemplate(this.dataSource), this.dataBase);
                    this.cache.put(type, simpleORM);
                }
            }
        }
        return simpleORM;
    }

    public String getDataBase() {
        return this.dataBase;
    }

    public void setDataBase(String dataBase) {
        this.dataBase = dataBase;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

