/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.component.sorm;

import cn.featherfly.common.db.builder.ConditionBuilder;
import cn.featherfly.common.db.data.Execution;
import cn.featherfly.common.db.data.SimpleExecution;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.db.metadata.DatabaseMetadataManager;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.component.sorm.SimpleORMException;
import cn.featherfly.component.sorm.mapping.ClassMapping;
import cn.featherfly.component.sorm.operate.DeleteOperate;
import cn.featherfly.component.sorm.operate.GetOperate;
import cn.featherfly.component.sorm.operate.InsertOperate;
import cn.featherfly.component.sorm.operate.MergeOperate;
import cn.featherfly.component.sorm.operate.QueryOperate;
import cn.featherfly.component.sorm.operate.UpdateOperate;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.springframework.jdbc.core.JdbcTemplate;

public class SimpleORM<T> {
    private InsertOperate<T> insertOperate;
    private UpdateOperate<T> updateOperate;
    private DeleteOperate<T> deleteOperate;
    private MergeOperate<T> mergeOperate;
    private GetOperate<T> getOperate;
    private QueryOperate<T> queryOperate;
    private DatabaseMetadata metadata;
    private Validator validator;

    public SimpleORM(Class<T> type, JdbcTemplate jdbcTemplate) {
        this.init(type, jdbcTemplate, null);
    }

    public SimpleORM(Class<T> type, JdbcTemplate jdbcTemplate, String dataBase) {
        this.init(type, jdbcTemplate, dataBase);
    }

    private void init(Class<T> type, JdbcTemplate jdbcTemplate, String dataBase) {
        AssertIllegalArgument.isNotNull((Object)jdbcTemplate, (String)"jdbcTemplate\u4e0d\u80fd\u4e3a\u7a7a");
        AssertIllegalArgument.isNotNull((Object)jdbcTemplate.getDataSource(), (String)"\u6570\u636e\u6e90\uff08jdbcTemplate.dataSource\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        this.metadata = DatabaseMetadataManager.getDefaultManager().create(jdbcTemplate.getDataSource());
        this.insertOperate = new InsertOperate<T>(type, jdbcTemplate, dataBase);
        this.updateOperate = new UpdateOperate<T>(type, jdbcTemplate, dataBase);
        this.deleteOperate = new DeleteOperate<T>(type, jdbcTemplate, dataBase);
        this.mergeOperate = new MergeOperate<T>(type, jdbcTemplate, dataBase);
        this.getOperate = new GetOperate<T>(type, jdbcTemplate, dataBase);
        this.queryOperate = new QueryOperate<T>(type, jdbcTemplate, dataBase);
        this.setGeneratedKey(true);
    }

    public int save(T entity) {
        Set cons;
        if (this.validator != null && LangUtils.isNotEmpty((Collection)(cons = this.validator.validate(entity, new Class[0])))) {
            StringBuilder errorMessage = new StringBuilder();
            for (ConstraintViolation constraintViolation : cons) {
                errorMessage.append(constraintViolation.getMessage()).append(",");
            }
            throw new SimpleORMException(errorMessage.toString());
        }
        return this.insertOperate.execute(entity);
    }

    public int update(T entity) {
        Set cons;
        if (this.validator != null && LangUtils.isNotEmpty((Collection)(cons = this.validator.validate(entity, new Class[0])))) {
            StringBuilder errorMessage = new StringBuilder();
            for (ConstraintViolation constraintViolation : cons) {
                errorMessage.append(constraintViolation.getMessage()).append(",");
            }
            throw new SimpleORMException(errorMessage.toString());
        }
        return this.updateOperate.execute(entity);
    }

    public void merge(T entity) {
        this.mergeOperate.execute(entity);
    }

    public int delete(T entity) {
        return this.deleteOperate.execute(entity);
    }

    public T get(Serializable id) {
        return this.getOperate.get(id);
    }

    public T load(T entity) {
        return this.getOperate.get(this.getOperate.getIdentity(entity));
    }

    public T unique(ConditionBuilder conditionBuilder) {
        return this.queryOperate.unique(conditionBuilder);
    }

    public T unique(String condition, Object ... params) {
        return this.queryOperate.unique(condition, params);
    }

    public List<T> list(ConditionBuilder conditionBuilder) {
        return this.queryOperate.list(conditionBuilder);
    }

    public List<T> list(String condition, Object ... params) {
        return this.queryOperate.list(condition, params);
    }

    public ClassMapping<T> getClassMapping(Class<T> type) {
        if (type == null) {
            return null;
        }
        return ClassMapping.getMappedClass(type, this.metadata);
    }

    public Serializable getIdentity(T entity) {
        if (entity == null) {
            return null;
        }
        return this.getOperate.getIdentity(entity);
    }

    public boolean isGeneratedKey() {
        return this.insertOperate.isGeneratedKey();
    }

    public void setGeneratedKey(boolean generatedKey) {
        this.insertOperate.setGeneratedKey(generatedKey);
    }

    public Execution getQueryExecution(ConditionBuilder conditionBuilder) {
        SimpleExecution execution = new SimpleExecution(this.queryOperate.getSql(conditionBuilder), conditionBuilder.getParams().toArray());
        return execution;
    }

    public Execution getGetExecution(Serializable id) {
        SimpleExecution execution = new SimpleExecution(this.getOperate.getSql(), new Object[]{id});
        return execution;
    }

    public Execution getSaveExecution(T entity) {
        this.insertOperate.execute(entity);
        SimpleExecution execution = new SimpleExecution(this.insertOperate.getSql(), this.insertOperate.getParameters(entity));
        return execution;
    }

    public Execution getUpdateExecution(T entity) {
        SimpleExecution execution = new SimpleExecution(this.updateOperate.getSql(), this.updateOperate.getParameters(entity));
        return execution;
    }

    public Execution getDeleteExecution(T entity) {
        SimpleExecution execution = new SimpleExecution(this.deleteOperate.getSql(), this.deleteOperate.getParameters(entity));
        return execution;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }
}

