/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.structure.tree;

import cn.featherfly.common.structure.tree.NodeExecutor;
import cn.featherfly.common.structure.tree.TreeNode;
import cn.featherfly.common.structure.tree.TreeNodeMatcher;
import cn.featherfly.common.structure.tree.util.TreeNodeTestUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tree<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tree.class);
    private TreeNode<E> rootNode;
    private boolean autoClearNodeList = true;

    private Tree(TreeNode<E> rootNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684node\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rootNode.isRoot()) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684node\u4e0d\u662f\u6839\u8282\u70b9");
        }
        this.rootNode = rootNode;
    }

    public Tree(List<TreeNode<E>> nodeList) {
        this.buildTree(nodeList);
    }

    private void buildTree(List<TreeNode<E>> nodeList) {
        if (nodeList != null) {
            Iterator<TreeNode<E>> iter = nodeList.iterator();
            while (iter.hasNext()) {
                TreeNode<E> node = iter.next();
                if (node == null || !node.isRoot()) continue;
                if (this.rootNode != null) {
                    throw new IllegalArgumentException("\u5728TreeNode\u96c6\u5408\u4e2d\u627e\u5230\u591a\u4e2a\u6839\u8282\u70b9");
                }
                this.rootNode = node;
                iter.remove();
            }
            if (this.rootNode == null) {
                throw new IllegalArgumentException("\u6ca1\u6709\u5728TreeNode\u96c6\u5408\u4e2d\u627e\u5230\u6839\u8282\u70b9");
            }
            iter = nodeList.iterator();
            while (iter.hasNext()) {
                this.addChildNode(nodeList, iter.next());
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("\n" + TreeNodeTestUtils.constract(this.getRootNode()));
            }
            if (this.autoClearNodeList) {
                LOGGER.debug("autoClearNodeList = {}\uff0c\u5df2\u7ecf\u81ea\u52a8\u6e05\u7406\u4f20\u5165\u7684nodeList", (Object)this.autoClearNodeList);
                nodeList.clear();
                nodeList = null;
            }
        }
    }

    private void addChildNode(List<TreeNode<E>> nodeList, TreeNode<E> childNode) {
        if (this.rootNode.isParent(childNode)) {
            this.rootNode.mergeChild(childNode);
        } else if (!this.rootNode.hasProgeny(childNode)) {
            this.addProgeny(nodeList, childNode);
        }
    }

    private void addProgeny(List<TreeNode<E>> nodes, TreeNode<E> progenyNode) {
        int index = nodes.indexOf(progenyNode.getParent());
        if (index < nodes.size() && index > -1) {
            TreeNode<E> progenyParent = nodes.get(index);
            progenyParent.mergeChild(progenyNode);
            this.addChildNode(nodes, progenyParent);
        }
    }

    public Tree<E> subTree(TreeNode<E> childNode) {
        return this.subTree(childNode.getId());
    }

    public Tree<E> subTree(String treeNodeId) {
        TreeNode node = (TreeNode)this.getRootNode().findTreeNode(treeNodeId);
        if (node != null) {
            TreeNode nodeCopy = (TreeNode)node.cloneAsRoot();
            return new Tree<E>(nodeCopy);
        }
        return null;
    }

    public TreeNode<E> find(TreeNodeMatcher<TreeNode<E>> matcher) {
        return (TreeNode)((Object)this.getRootNode().findTreeNode(matcher));
    }

    public TreeNode<E> find(String id) {
        return (TreeNode)this.getRootNode().findTreeNode(id);
    }

    public TreeNode<E> find(TreeNode<E> node) {
        return this.getRootNode().findTreeNode(node);
    }

    public List<TreeNode<E>> getEveryNode() {
        return this.getRootNode().getEveryNode();
    }

    public void sort(Comparator<TreeNode<E>> comparator) {
        this.getRootNode().sort(comparator, true);
    }

    public void each(NodeExecutor<TreeNode<E>> executor) {
        this.getRootNode().each(executor);
    }

    public TreeNode<E> getRootNode() {
        return this.rootNode;
    }

    public boolean isAutoClearNodeList() {
        return this.autoClearNodeList;
    }

    public void setAutoClearNodeList(boolean autoClearNodeList) {
        this.autoClearNodeList = autoClearNodeList;
    }
}

