/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.structure.page;

import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.common.structure.page.Pagination;

public class SimplePagination
implements Pagination {
    private Integer total;
    private Integer pageSize;
    private Integer pageNumber;

    public SimplePagination() {
    }

    public SimplePagination(Limit limit) {
        this(limit.getOffset(), limit.getLimit());
    }

    public SimplePagination(int offset, int limit) {
        this.pageSize = limit;
        this.pageNumber = (offset + limit) / limit;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    @Override
    public Integer getTotalPage() {
        return (this.getTotal() + this.pageSize - 1) / this.pageSize;
    }

    @Override
    public Integer getTotal() {
        return this.total;
    }

    @Override
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Override
    public Integer getPageNumber() {
        return this.pageNumber;
    }
}

