/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.storage.file;

import cn.featherfly.common.io.FileUtils;
import cn.featherfly.common.storage.file.FileLocalDirStorage;
import cn.featherfly.common.storage.file.FileStorage;
import cn.featherfly.common.storage.file.RemoteFileStorage;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLocalAndRemoteStorage
implements FileStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLocalAndRemoteStorage.class);
    private FileLocalDirStorage localDirStorage;
    private List<RemoteFileStorage> remoteStorages;

    public FileLocalAndRemoteStorage(FileLocalDirStorage localDirStorage, List<RemoteFileStorage> remoteStorages) {
        ASSERT.isNotNull(localDirStorage, "localDirStorage");
        ASSERT.isNotEmpty(remoteStorages, "remoteStorages");
        this.localDirStorage = localDirStorage;
        this.remoteStorages = remoteStorages;
    }

    @Override
    public File retrieve(String id) {
        File file = this.localDirStorage.retrieve(id);
        if (file != null && file.exists()) {
            LOGGER.debug("\u4f7f\u7528\u672c\u5730\u5b58\u50a8[{}]\u67e5\u627e\u6587\u4ef6\u5b58\u50a8\u552f\u4e00\u6807\u793a[{}]\u7684\u6587\u4ef6\uff0c\u627e\u5230\u6587\u4ef6\uff1a{}", new Object[]{this.localDirStorage, id, file.getAbsolutePath()});
            return file;
        }
        LOGGER.debug("\u4f7f\u7528\u672c\u5730\u5b58\u50a8[{}]\u67e5\u627e\u6587\u4ef6\u5b58\u50a8\u552f\u4e00\u6807\u793a[{}]\u7684\u6587\u4ef6\uff0c\u672a\u627e\u5230", (Object)this.localDirStorage, (Object)id);
        for (RemoteFileStorage remoteStorage : this.remoteStorages) {
            file = (File)remoteStorage.retrieve(id);
            if (file != null && file.exists()) {
                LOGGER.debug("\u4f7f\u7528\u8fdc\u7a0b\u5b58\u50a8[{}]\u67e5\u627e\u6587\u4ef6\u5b58\u50a8\u552f\u4e00\u6807\u793a[{}]\u7684\u6587\u4ef6\uff0c\u627e\u5230\u6587\u4ef6\uff1a{}", new Object[]{remoteStorage, id, file.getAbsolutePath()});
                return file;
            }
            LOGGER.debug("\u4f7f\u7528\u8fdc\u7a0b\u5b58\u50a8[{}]\u67e5\u627e\u6587\u4ef6\u5b58\u50a8\u552f\u4e00\u6807\u793a[{}]\u7684\u6587\u4ef6\uff0c\u672a\u627e\u5230", new Object[]{remoteStorage, id});
        }
        return null;
    }

    @Override
    public String store(File file) {
        String id = this.localDirStorage.store(file);
        LOGGER.debug("\u4f7f\u7528\u672c\u5730\u5b58\u50a8[{}]\u5b58\u50a8\u6307\u5b9a\u6587\u4ef6[{}]\uff0c\u4ea7\u751f\u5b58\u50a8\u8bc6\u522b\u4fe1\u606f\uff1a{}", new Object[]{this.localDirStorage, file.getAbsolutePath(), id});
        for (RemoteFileStorage remoteStorage : this.remoteStorages) {
            String rid = (String)remoteStorage.store(file);
            if (file == null || !file.exists()) continue;
            LOGGER.debug("\u4f7f\u7528\u8fdc\u7a0b\u5b58\u50a8[{}]\u5b58\u50a8\u6307\u5b9a\u6587\u4ef6[{}]\uff0c\u4ea7\u751f\u5b58\u50a8\u8bc6\u522b\u4fe1\u606f\uff1a{}", new Object[]{remoteStorage, file.getAbsolutePath(), rid});
        }
        return id;
    }

    @Override
    public boolean delete(String id) {
        File file = this.retrieve(id);
        return FileUtils.delete(file);
    }
}

