/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.locale;

import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.ServiceLoaderUtils;
import cn.featherfly.common.locale.DefaultLocaleManager;
import cn.featherfly.common.locale.JdkResourceBundleFactory;
import cn.featherfly.common.locale.LocaleManager;
import cn.featherfly.common.locale.ResourceBundle;
import cn.featherfly.common.locale.ResourceBundleFactory;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceBundleUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleUtils.class);
    private static final ResourceBundleFactory RESOURCE_BUNDLE_FACTORY = ServiceLoaderUtils.load(ResourceBundleFactory.class, new JdkResourceBundleFactory());
    private static final LocaleManager LOCALE_MANAGER = ServiceLoaderUtils.load(LocaleManager.class, new DefaultLocaleManager());
    public static final char RESOURCE_SIGN = '@';
    public static final char KEY_SIGN = '#';

    private ResourceBundleUtils() {
    }

    public static Locale getLocale() {
        return LOCALE_MANAGER.getLocale();
    }

    public static ResourceBundle getBundle(String baseName) {
        return RESOURCE_BUNDLE_FACTORY.getBundle(baseName, LOCALE_MANAGER.getLocale());
    }

    public static ResourceBundle getBundle(String baseName, Locale locale) {
        return RESOURCE_BUNDLE_FACTORY.getBundle(baseName, locale);
    }

    public static String getString(String pattern) {
        return ResourceBundleUtils.getString(pattern, null);
    }

    public static String getString(String pattern, Object[] argus) {
        return ResourceBundleUtils.getString(pattern, argus, LOCALE_MANAGER.getLocale());
    }

    public static String getString(String pattern, Object[] argus, Locale locale) {
        String baseName = null;
        String key = null;
        int keyIndex = pattern.indexOf(35);
        char firstChar = pattern.charAt(0);
        if (firstChar == '@' && keyIndex != -1) {
            baseName = pattern.substring(1, pattern.indexOf(35));
            key = pattern.substring(pattern.indexOf(35) + 1);
            return ResourceBundleUtils.getStringFromBundle(pattern, baseName, key, argus, locale);
        }
        throw new IllegalArgumentException("argu code must start with @ and split bundle baseName and key with #, example: @bundleBaseName#key");
    }

    public static String getString(String baseName, String key, Object[] argus, Locale locale) {
        return ResourceBundleUtils.getStringFromBundle(baseName, key, argus, locale);
    }

    public static String getString(Class<?> type, String key) {
        return ResourceBundleUtils.getString(type, key, ResourceBundleUtils.getLocale());
    }

    public static String getString(Class<?> type, String key, Locale locale) {
        return ResourceBundleUtils.getString(type, key, new Object[0], locale);
    }

    public static String getString(Class<?> type, String key, Object[] argus) {
        return ResourceBundleUtils.getString(type, key, argus, ResourceBundleUtils.getLocale());
    }

    public static String getString(Class<?> type, String key, Object[] argus, Locale locale) {
        try {
            return ResourceBundleUtils.getString(type.getName(), key, argus, locale);
        }
        catch (MissingResourceException e) {
            return ResourceBundleUtils.getString(type.getSimpleName(), key, argus, locale);
        }
    }

    private static String getStringFromBundle(String baseName, String key, Object[] argus, Locale locale) {
        if (locale == null) {
            locale = ResourceBundleUtils.getLocale();
        }
        String string = ResourceBundleUtils.format(ResourceBundleUtils.getBundle(baseName, locale).getString(key), argus);
        return string;
    }

    private static String getStringFromBundle(String code, String baseName, String key, Object[] argus, Locale locale) {
        if (locale == null) {
            locale = ResourceBundleUtils.getLocale();
        }
        String string = ResourceBundleUtils.format(ResourceBundleUtils.getBundle(baseName, locale).getString(key), argus);
        LOGGER.debug("match ResourceBundle pattern -> [{}] : baseName[{}] and key[{}], message -> {}", new Object[]{code, baseName, key, string});
        return string;
    }

    private static String format(String string, Object[] argus) {
        if (LangUtils.isNotEmpty(argus)) {
            return MessageFormat.format(string, argus);
        }
        return string;
    }
}

