/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang.asserts;

import cn.featherfly.common.exception.LocalizedExceptionUtils;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.common.lang.asserts.ILocalizedAssert;
import java.io.File;
import java.util.Collection;
import java.util.Map;

public class LocalizedAssert<E extends RuntimeException>
implements ILocalizedAssert<E> {
    private Class<E> exceptionType;

    public LocalizedAssert(Class<E> exceptionType) {
        this.exceptionType = exceptionType;
    }

    @Override
    public void isNotNull(Object object, String arg) {
        if (object == null) {
            this.throwException("#isNotNull", arg);
        }
    }

    @Override
    public void isNotBlank(String text, String arg) {
        if (!StringUtils.isNotBlank(text)) {
            this.throwException("#isNotBlank", arg);
        }
    }

    @Override
    public void isNotEmpty(Object obj, String args) {
        if (!LangUtils.isNotEmpty(obj)) {
            this.throwException("#isNotEmpty", args);
        }
    }

    @Override
    public void isNotEmpty(String text, String arg) {
        if (!LangUtils.isNotEmpty(text)) {
            this.throwException("#isNotEmpty", arg);
        }
    }

    @Override
    public void isNotEmpty(Object[] array, String arg) {
        if (LangUtils.isEmpty(array)) {
            this.throwException("#isNotEmpty", arg);
        }
    }

    @Override
    public void isNotEmpty(Collection<?> collection, String arg) {
        if (LangUtils.isEmpty(collection)) {
            this.throwException("#isNotEmpty", arg);
        }
    }

    @Override
    public void isNotEmpty(Map<?, ?> map, String arg) {
        if (LangUtils.isEmpty(map)) {
            this.throwException("#isNotEmpty", arg);
        }
    }

    @Override
    public void isExists(File file, String args) {
        if (file == null) {
            this.throwException("#isExists", args, "null");
        } else if (!file.exists()) {
            this.throwException("#isExists", args, file.getAbsolutePath());
        }
    }

    @Override
    public void isFile(File file, String args) {
        if (file == null) {
            this.throwException("#isFile", args, "null");
        } else if (!file.isFile()) {
            this.throwException("#isFile", args, file.getAbsolutePath());
        }
    }

    @Override
    public void isDirectory(File file, String args) {
        if (file == null) {
            this.throwException("#isDirectory", args, "null");
        } else if (!file.isDirectory()) {
            this.throwException("#isDirectory", args, file.getAbsolutePath());
        }
    }

    @Override
    public void isInstanceOf(Class<?> clazz, Object obj) {
        Object[] args = new Object[]{clazz == null ? "null" : clazz.getName(), obj == null ? "null" : obj.getClass().getName()};
        if (clazz == null || !clazz.isInstance(obj)) {
            this.throwException("#isInstanceOf", args);
        }
    }

    @Override
    public void isParent(Class<?> parentType, Class<?> subType) {
        Object[] args = new Object[]{parentType == null ? "null" : parentType.getName(), subType == null ? "null" : subType.getName()};
        if (!ClassUtils.isParent(parentType, subType)) {
            this.throwException("#isParent", args);
        }
    }

    @Override
    public void isNotInterface(Class<?> classType) {
        if (classType != null && classType.isInterface()) {
            this.throwException("#isNotInterface", classType.getName());
        }
    }

    private void throwException(String msg, Object ... args) {
        msg = "@assert" + msg;
        LocalizedExceptionUtils.throwException(this.exceptionType, msg, args);
    }

    @Override
    public void isInRange(int value, int min, int max, String arguDescp) {
        if (value < min || value > max) {
            this.throwException("#isInRange", value, min, max, arguDescp);
        }
    }

    @Override
    public void isGt(int value, int min, String arguDescp) {
        if (value <= min) {
            this.throwException("#isGt", value, min, arguDescp);
        }
    }

    @Override
    public void isGe(int value, int min, String arguDescp) {
        if (value < min) {
            this.throwException("#isGe", value, min, arguDescp);
        }
    }

    @Override
    public void isLt(int value, int max, String arguDescp) {
        if (value >= max) {
            this.throwException("#isLt", value, max, arguDescp);
        }
    }

    @Override
    public void isLe(int value, int max, String arguDescp) {
        if (value > max) {
            this.throwException("#isLe", value, max, arguDescp);
        }
    }
}

