/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public final class ServiceLoaderUtils {
    private ServiceLoaderUtils() {
    }

    public static <T> T load(Class<T> serviceType) {
        return ServiceLoaderUtils.load(serviceType, null);
    }

    public static <T> T load(Class<T> serviceType, T defaultService) {
        return ServiceLoaderUtils.load(serviceType, defaultService, MultiPolicy.EXCEPTION, NotFoundPolicy.exception);
    }

    public static <T> T load(Class<T> serviceType, T defaultService, MultiPolicy multyPolicy, NotFoundPolicy notFoundPolicy) {
        List<T> factorys = ServiceLoaderUtils.loadAll(serviceType);
        if (factorys.size() > 1) {
            if (multyPolicy == null) {
                multyPolicy = MultiPolicy.EXCEPTION;
            }
            switch (multyPolicy) {
                case FIRST: {
                    return factorys.get(0);
                }
                case LAST: {
                    return factorys.get(factorys.size() - 1);
                }
            }
            throw new IllegalArgumentException("\u627e\u5230\u591a\u4e2a" + serviceType.getName() + "\u5b9e\u73b0 -> " + factorys);
        }
        if (factorys.isEmpty()) {
            return ServiceLoaderUtils.loadOnNotFound(serviceType, defaultService, notFoundPolicy);
        }
        return factorys.get(0);
    }

    private static <T> T loadOnNotFound(Class<T> serviceType, T defaultService, NotFoundPolicy notFoundPolicy) {
        if (defaultService == null) {
            switch (notFoundPolicy) {
                case ignore: {
                    return null;
                }
            }
            throw new IllegalArgumentException("\u6ca1\u6709\u627e\u5230" + serviceType.getName() + "\u5b9e\u73b0");
        }
        return defaultService;
    }

    public static <T> List<T> loadAll(Class<T> serviceType) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(serviceType);
        ArrayList<T> services = new ArrayList<T>();
        for (T service : serviceLoader) {
            services.add(service);
        }
        return services;
    }

    public static enum NotFoundPolicy {
        exception,
        ignore;

    }

    public static enum MultiPolicy {
        EXCEPTION,
        FIRST,
        LAST;

    }
}

