/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.AssertIllegalArgument;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class RandomUtils {
    private static final int LETTER_NUMBER = 25;
    private static final int LOWERCASE_START = 97;
    private static final int UPPERCASE_START = 65;
    private static final int NUMBER = 10;
    private static final int NUMBER_START = 48;
    private static Random random = new Random();

    private RandomUtils() {
    }

    public static void setSeed(long seed) {
        random.setSeed(seed);
    }

    public static char getRandomLetter() {
        if (RandomUtils.getRandomBoolean()) {
            return RandomUtils.getRandomLetterLowerCase();
        }
        return RandomUtils.getRandomLetterUpperCase();
    }

    public static char getRandomLetterUpperCase() {
        return (char)(random.nextInt(25) + 65);
    }

    public static char getRandomLetterLowerCase() {
        return (char)(random.nextInt(25) + 97);
    }

    public static char getRandomNumber() {
        return (char)(random.nextInt(10) + 48);
    }

    public static char getRandomWord() {
        int type = 3;
        int sign = random.nextInt(3);
        if (sign == 0) {
            return RandomUtils.getRandomNumber();
        }
        if (sign == 1) {
            return RandomUtils.getRandomLetterLowerCase();
        }
        return RandomUtils.getRandomLetterUpperCase();
    }

    public static boolean getRandomBoolean() {
        return random.nextBoolean();
    }

    public static int getRandomInt() {
        return random.nextInt();
    }

    public static int getRandomInt(int max) {
        return random.nextInt(max);
    }

    public static double getRandomDouble() {
        return random.nextDouble();
    }

    public static double getRandomFloat() {
        return random.nextFloat();
    }

    public static double getRandomLong() {
        return random.nextLong();
    }

    public static double getRandomGaussian() {
        return random.nextGaussian();
    }

    public static String getRandomString(int length) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            result.append(RandomUtils.getRandomWord());
        }
        return result.toString();
    }

    public static String getRandomString(int length, CharType ... charTypes) {
        int i;
        StringBuilder result = new StringBuilder();
        boolean[] signTemp = new boolean[]{false, false, false};
        for (int i2 = 0; charTypes != null && i2 < charTypes.length; ++i2) {
            CharType type = charTypes[i2];
            if (type == CharType.LOWER_CASE) {
                signTemp[0] = true;
                continue;
            }
            if (type == CharType.UPPER_CASE) {
                signTemp[1] = true;
                continue;
            }
            if (type != CharType.NUMBER_CASE) continue;
            signTemp[2] = true;
        }
        ArrayList<Integer> signList = new ArrayList<Integer>();
        for (i = 0; i < signTemp.length; ++i) {
            if (!signTemp[i]) continue;
            signList.add(i);
        }
        if (signList.size() > 0) {
            for (i = 0; i < length; ++i) {
                int signIndex = random.nextInt(signList.size());
                int index = (Integer)signList.get(signIndex);
                if (index == 0) {
                    result.append(RandomUtils.getRandomLetterLowerCase());
                    continue;
                }
                if (index == 1) {
                    result.append(RandomUtils.getRandomLetterUpperCase());
                    continue;
                }
                result.append(RandomUtils.getRandomNumber());
            }
        } else {
            for (i = 0; i < length; ++i) {
                result.append(RandomUtils.getRandomWord());
            }
        }
        return result.toString();
    }

    public static <T> T getRandom(List<T> source) {
        RandomUtils.checkSource(source);
        int index = RandomUtils.getRandomInt(source.size());
        return source.get(index);
    }

    public static <T> String getRandomString(List<T> source, int length) {
        RandomUtils.checkSource(source);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = RandomUtils.getRandomInt(source.size());
            sb.append(source.get(index));
        }
        return sb.toString();
    }

    public static double[] getRandomFromTotal(double total, int num) {
        double[] results = new double[num];
        LeftMoneyPackage leftMoneyPackage = new LeftMoneyPackage(total, num);
        int i = 0;
        while (leftMoneyPackage.remainSize > 0) {
            results[i] = RandomUtils.getRandomMoney(leftMoneyPackage);
            ++i;
        }
        return results;
    }

    private static double getRandomMoney(LeftMoneyPackage _leftMoneyPackage) {
        if (_leftMoneyPackage.remainSize == 1) {
            LeftMoneyPackage leftMoneyPackage = _leftMoneyPackage;
            Integer n = leftMoneyPackage.remainSize;
            Integer n2 = leftMoneyPackage.remainSize = leftMoneyPackage.remainSize - 1;
            return (double)Math.round(_leftMoneyPackage.remainMoney * 100.0) / 100.0;
        }
        Random r = new Random();
        double min = 0.01;
        double max = _leftMoneyPackage.remainMoney / (double)_leftMoneyPackage.remainSize.intValue() * 2.0;
        double money = r.nextDouble() * max;
        money = money <= min ? 0.01 : money;
        money = Math.floor(money * 100.0) / 100.0;
        LeftMoneyPackage leftMoneyPackage = _leftMoneyPackage;
        Integer n = leftMoneyPackage.remainSize;
        Integer n3 = leftMoneyPackage.remainSize = leftMoneyPackage.remainSize - 1;
        leftMoneyPackage = _leftMoneyPackage;
        leftMoneyPackage.remainMoney = leftMoneyPackage.remainMoney - money;
        return money;
    }

    private static <T> void checkSource(List<T> source) {
        AssertIllegalArgument.isNotEmpty(source, "List<T> source");
    }

    private static class LeftMoneyPackage {
        private Integer remainSize;
        private Double remainMoney;

        public LeftMoneyPackage(Double remainMoney, Integer remainSize) {
            this.remainSize = remainSize;
            this.remainMoney = remainMoney;
        }
    }

    public static enum CharType {
        LOWER_CASE,
        UPPER_CASE,
        NUMBER_CASE;

    }
}

