/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.LangUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;

public final class NumberUtils {
    private NumberUtils() {
    }

    public static <T extends Number> T convert(Number number, Class<T> targetClass) {
        return NumberUtils.value(number, targetClass);
    }

    public static <T extends Number> T value(Number number, Class<T> toType) {
        if (number == null) {
            return null;
        }
        Number value = null;
        if (toType == Integer.class || toType == Integer.TYPE) {
            value = new Integer(number.intValue());
        } else if (toType == Long.class || toType == Long.TYPE) {
            value = new Long(number.longValue());
        } else if (toType == Double.class || toType == Double.TYPE) {
            value = new Double(number.doubleValue());
        } else if (toType == Float.class || toType == Float.TYPE) {
            value = new Float(number.floatValue());
        } else if (toType == BigInteger.class) {
            value = new BigInteger(number.toString());
        } else if (toType == BigDecimal.class) {
            value = new BigDecimal(number.toString());
        } else if (toType == Byte.class || toType == Byte.TYPE) {
            value = new Byte(number.byteValue());
        } else if (toType == Short.class || toType == Short.TYPE) {
            value = new Short(number.shortValue());
        }
        if (value != null) {
            return (T)value;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u76ee\u6807\u7c7b\u578b\uff1a" + toType.getName());
    }

    public static <T extends Number> T parse(String source, Class<T> toType) {
        if (LangUtils.isEmpty(source)) {
            return null;
        }
        Number value = null;
        if (toType == Integer.class || toType == Integer.TYPE) {
            value = new Integer(Integer.parseInt(source));
        } else if (toType == Long.class || toType == Long.TYPE) {
            value = new Long(Long.parseLong(source));
        } else if (toType == Double.class || toType == Double.TYPE) {
            value = new Double(Double.parseDouble(source));
        } else if (toType == Float.class || toType == Float.TYPE) {
            value = new Float(Float.parseFloat(source));
        } else if (toType == BigInteger.class) {
            value = new BigInteger(source);
        } else if (toType == BigDecimal.class) {
            value = new BigDecimal(source);
        } else if (toType == Byte.class || toType == Byte.TYPE) {
            value = new Byte(Byte.parseByte(source));
        } else if (toType == Short.class || toType == Short.TYPE) {
            value = new Short(Short.parseShort(source));
        }
        if (value != null) {
            return (T)value;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u76ee\u6807\u7c7b\u578b\uff1a" + toType.getName());
    }

    public static Byte parse(String target, Byte defaultValue) {
        try {
            return Byte.parseByte(target);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Integer parse(String target, Integer defaultValue) {
        try {
            return Integer.parseInt(target);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long parse(String target, Long defaultValue) {
        try {
            return Long.parseLong(target);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Double parse(String target, Double defaultValue) {
        try {
            return Double.parseDouble(target);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Float parse(String target, Float defaultValue) {
        try {
            return Float.valueOf(Float.parseFloat(target));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <N extends Number> String fillingAtStart(N number, int minLength, char sign) {
        AssertIllegalArgument.isNotNull(number, "N number");
        int requiredLength = minLength - number.toString().length();
        if (requiredLength > 0) {
            StringBuilder pattern = new StringBuilder("'");
            for (int i = 0; i < requiredLength; ++i) {
                pattern.append(sign);
            }
            pattern.append("'#");
            return new DecimalFormat(pattern.toString()).format(number);
        }
        return number.toString();
    }

    public static byte[] toByteArray(int intSource) {
        byte[] bLocalArr = new byte[4];
        for (int i = 0; i < 4 && i < 4; ++i) {
            bLocalArr[i] = (byte)(intSource >> 8 * i & 0xFF);
        }
        return bLocalArr;
    }

    public static int toInt(byte[] bytes) {
        int iOutcome = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte bLoop = bytes[i];
            iOutcome += (bLoop & 0xFF) << 8 * i;
        }
        return iOutcome;
    }

    public static byte[] toByteArray(short shortSource) {
        byte[] bLocalArr = new byte[2];
        for (int i = 0; i < 4 && i < 2; ++i) {
            bLocalArr[i] = (byte)(shortSource >> 8 * i & 0xFF);
        }
        return bLocalArr;
    }

    public static short toShort(byte[] bytes) {
        short iOutcome = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte bLoop = bytes[i];
            iOutcome = (short)(iOutcome + ((bLoop & 0xFF) << 8 * i));
        }
        return iOutcome;
    }
}

