/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class LangUtils {
    private LangUtils() {
    }

    public static <T> T pick(T target, T defaultTarget) {
        return target == null ? defaultTarget : target;
    }

    @SafeVarargs
    public static <T> T pickFirst(T ... pickedItems) {
        if (pickedItems != null) {
            for (T t : pickedItems) {
                if (t == null) continue;
                return t;
            }
        }
        return null;
    }

    @SafeVarargs
    public static <T> T pickLast(T ... pickedItems) {
        if (pickedItems != null) {
            for (int i = pickedItems.length - 1; i >= 0; --i) {
                T t = pickedItems[i];
                if (t == null) continue;
                return t;
            }
        }
        return null;
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return LangUtils.isEmpty((String)object);
        }
        if (object instanceof Collection) {
            return LangUtils.isEmpty((Collection)object);
        }
        if (object instanceof Map) {
            return LangUtils.isEmpty((Map)object);
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        return false;
    }

    public static boolean isNotEmpty(Object object) {
        return !LangUtils.isEmpty(object);
    }

    public static boolean isEmpty(String string) {
        return string == null || "".equals(string);
    }

    public static boolean isNotEmpty(String string) {
        return !LangUtils.isEmpty(string);
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(Object[] array) {
        return !LangUtils.isEmpty(array);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !LangUtils.isEmpty(collection);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !LangUtils.isEmpty(map);
    }

    public static boolean isExists(File file) {
        return file != null && file.exists();
    }

    public static <T extends Enum<T>> T toEnum(Class<T> toClass, Object object) {
        if (object != null) {
            if (object instanceof String[]) {
                return LangUtils.toEnum(toClass, ((String[])object)[0]);
            }
            if (object instanceof String) {
                return LangUtils.toEnum(toClass, (String)object);
            }
            if (object instanceof Integer || object.getClass() == Integer.TYPE) {
                Integer ordinal = (Integer)object;
                return LangUtils.toEnum(toClass, ordinal);
            }
            if (object instanceof Byte || object.getClass() == Byte.TYPE) {
                Byte ordinal = (Byte)object;
                return LangUtils.toEnum(toClass, new Integer(ordinal.byteValue()));
            }
            if (object instanceof Short || object.getClass() == Short.TYPE) {
                Short ordinal = (Short)object;
                return LangUtils.toEnum(toClass, new Integer(ordinal.shortValue()));
            }
        }
        return null;
    }

    private static <T extends Enum<T>> T toEnum(Class<T> toClass, String value) {
        try {
            int ordinal = Integer.parseInt(value);
            return LangUtils.toEnum(toClass, ordinal);
        }
        catch (NumberFormatException e) {
            return Enum.valueOf(toClass, value);
        }
    }

    private static <T extends Enum<T>> T toEnum(Class<T> toClass, Integer ordinal) {
        Enum[] es;
        for (Enum e : es = (Enum[])toClass.getEnumConstants()) {
            if (e.ordinal() != ordinal.intValue()) continue;
            return (T)e;
        }
        return null;
    }

    public static boolean equals(Object target, Object otherTarget) {
        return target == otherTarget || target != null && target.equals(otherTarget);
    }

    public static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static String toString(Object obj, String defaultValue) {
        return obj != null ? obj.toString() : defaultValue;
    }

    public static String toString(Object obj) {
        return LangUtils.toString(obj, null);
    }

    public static StackTraceElement getInvoker() {
        String methodName = "getInvoker";
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            StackTraceElement[] stackTraceElements = entry.getValue();
            boolean findThis = false;
            boolean findInvokeThis = false;
            boolean findInvokor = false;
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                if (findThis) {
                    findInvokeThis = true;
                    findThis = false;
                }
                if (stackTraceElement.getClassName().equals(LangUtils.class.getName()) && stackTraceElement.getMethodName().equals("getInvoker")) {
                    findThis = true;
                }
                if (findInvokor) {
                    return stackTraceElement;
                }
                if (!findInvokeThis) continue;
                findInvokeThis = false;
                findInvokor = true;
            }
        }
        return null;
    }

    public static List<StackTraceElement> getInvokers() {
        String methodName = "getInvokers";
        ArrayList<StackTraceElement> invokers = new ArrayList<StackTraceElement>();
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            StackTraceElement[] stackTraceElements = entry.getValue();
            boolean findThis = false;
            boolean findInvokeThis = false;
            boolean findInvokor = false;
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                if (findThis) {
                    findInvokeThis = true;
                    findThis = false;
                }
                if (stackTraceElement.getClassName().equals(LangUtils.class.getName()) && stackTraceElement.getMethodName().equals("getInvokers")) {
                    findThis = true;
                }
                if (findInvokor) {
                    invokers.add(stackTraceElement);
                }
                if (!findInvokeThis) continue;
                findInvokeThis = false;
                findInvokor = true;
            }
        }
        return invokers;
    }
}

