/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.exception.ReflectException;
import cn.featherfly.common.lang.ClassUtils;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class LambdaUtils {
    private static final Map<SerializedLambda, String> CACHE_LAMBDA_NAME = new ConcurrentHashMap<SerializedLambda, String>(8);

    public static SerializedLambdaInfo getLambdaInfo(Serializable lambda) {
        return LambdaUtils.getLambdaInfo(LambdaUtils.getSerializedLambda(lambda));
    }

    public static SerializedLambdaInfo getLambdaInfo(SerializedLambda lambda) {
        SerializedLambdaInfo info = new SerializedLambdaInfo();
        info.serializedLambda = lambda;
        info.methodDeclaredClassName = lambda.getImplClass().replaceAll("/", ".");
        info.methodName = lambda.getImplMethodName();
        info.methodInstanceClassName = StringUtils.substringBefore((String)lambda.getInstantiatedMethodType(), (String)";").substring(2).replaceAll("/", ".");
        info.method = ClassUtils.findMethod(ClassUtils.forName(info.methodDeclaredClassName), o -> lambda.getCapturedArgCount() == o.getParameterCount() && o.getName().equals(info.methodName));
        return info;
    }

    public static Method getLambdaMethod(Serializable lambda) {
        return LambdaUtils.getLambdaMethod(LambdaUtils.getSerializedLambda(lambda));
    }

    public static Method getLambdaMethod(SerializedLambda lambda) {
        String className = lambda.getImplClass().replaceAll("/", ".");
        String methodName = lambda.getImplMethodName();
        Method method = ClassUtils.findMethod(ClassUtils.forName(className), o -> lambda.getCapturedArgCount() == o.getParameterCount() && o.getName().equals(methodName));
        return method;
    }

    public static SerializedLambda getSerializedLambda(Serializable lambda) {
        return LambdaUtils.computeSerializedLambda(lambda);
    }

    public static String getLambdaMethodName(Serializable lambda) {
        SerializedLambda serializedLambda = LambdaUtils.computeSerializedLambda(lambda);
        return LambdaUtils.getLambdaMethodName(serializedLambda);
    }

    public static String getLambdaMethodName(SerializedLambda lambda) {
        return LambdaUtils.getMethodName(lambda);
    }

    public static String getLambdaPropertyName(Serializable lambda) {
        SerializedLambda serializedLambda = LambdaUtils.computeSerializedLambda(lambda);
        return LambdaUtils.getLambdaPropertyName(serializedLambda);
    }

    public static String getLambdaPropertyName(SerializedLambda lambda) {
        return LambdaUtils.getPropertyName(lambda);
    }

    private static SerializedLambda computeSerializedLambda(Serializable lambda) {
        try {
            Class<?> cl = lambda.getClass();
            Method m = cl.getDeclaredMethod("writeReplace", new Class[0]);
            m.setAccessible(true);
            Object replacement = m.invoke((Object)lambda, new Object[0]);
            if (!(replacement instanceof SerializedLambda)) {
                return null;
            }
            return (SerializedLambda)replacement;
        }
        catch (Exception e) {
            throw new ReflectException("get SerializedLambda fail", e);
        }
    }

    private static String getMethodName(SerializedLambda serializedLambda) {
        String name = CACHE_LAMBDA_NAME.get(serializedLambda);
        if (null != name) {
            return name;
        }
        String methodName = serializedLambda.getImplMethodName();
        CACHE_LAMBDA_NAME.put(serializedLambda, methodName);
        return methodName;
    }

    private static String getPropertyName(SerializedLambda serializedLambda) {
        String methodName = LambdaUtils.getMethodName(serializedLambda);
        return LambdaUtils.methodToPropertyName(methodName);
    }

    private static String methodToPropertyName(String methodName) {
        String name = null;
        name = methodName.startsWith("get") ? methodName.substring(3) : (methodName.startsWith("is") ? methodName.substring(2) : methodName);
        if (name != null) {
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name;
    }

    public static class SerializedLambdaInfo {
        private String methodName;
        private String methodDeclaredClassName;
        private String methodInstanceClassName;
        private Method method;
        private SerializedLambda serializedLambda;

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodDeclaredClassName() {
            return this.methodDeclaredClassName;
        }

        public String getMethodInstanceClassName() {
            return this.methodInstanceClassName;
        }

        public SerializedLambda getSerializedLambda() {
            return this.serializedLambda;
        }

        public Method getMethod() {
            return this.method;
        }

        public String toString() {
            return "SerializedLambdaInfo [methodName=" + this.methodName + ", methodDeclaredClassName=" + this.methodDeclaredClassName + ", methodInstanceClassName=" + this.methodInstanceClassName + ", method=" + this.method + ", serializedLambda=" + this.serializedLambda + "]";
        }
    }
}

