/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Map;

public class Assert {
    protected Class<?> exception;

    public <E extends RuntimeException> Assert(Class<E> exceptionType) {
        this.exception = exceptionType;
    }

    public void isNotNull(Object object, String message) {
        if (object == null) {
            this.throwException(message);
        }
    }

    public void isNotNull(Object object) {
        this.isNotNull(object, "\u53c2\u6570\u4e0d\u80fd\u4e3anull");
    }

    public void isTrue(boolean expression, String message) {
        if (!expression) {
            this.throwException(message);
        }
    }

    public void isFalse(boolean expression, String message) {
        if (expression) {
            this.throwException(message);
        }
    }

    public void isNotBlank(String text, String message) {
        if (!StringUtils.isNotBlank(text)) {
            this.throwException(message);
        }
    }

    public void isNotBlank(String text) {
        this.isNotBlank(text, "\u53c2\u6570\u5fc5\u987b\u662f\u4e00\u4e2a\u6709\u6548\u5b57\u7b26\u4e32;null\uff0c\u7a7a\u5b57\u7b26\u4e32\uff0c\u53ea\u6709\u7a7a\u767d\u5b57\u7b26\u7684\u5b57\u7b26\u4e32\u90fd\u4e0d\u662f\u6709\u6548\u5b57\u7b26\u4e32");
    }

    public void isNotEmpty(Object obj, String message) {
        if (!LangUtils.isNotEmpty(obj)) {
            this.throwException(message);
        }
    }

    public void isNotEmpty(Object obj) {
        this.isNotEmpty(obj, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void isNotEmpty(String text, String message) {
        if (!LangUtils.isNotEmpty(text)) {
            this.throwException(message);
        }
    }

    public void isNotEmpty(String text) {
        this.isNotEmpty(text, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff08null\uff0c\u7a7a\u5b57\u7b26\u4e32\uff09");
    }

    public void isNotEmpty(Object[] array, String message) {
        if (LangUtils.isEmpty(array)) {
            this.throwException(message);
        }
    }

    public void isNotEmpty(Object[] array) {
        this.isNotEmpty(array, "\u53c2\u6570\u6570\u7ec4\u4e0d\u80fd\u4e3anull\u4e14\u957f\u5ea6\u4e0d\u80fd\u4e3a0");
    }

    public void isNotEmpty(Collection<?> collection, String message) {
        if (LangUtils.isEmpty(collection)) {
            this.throwException(message);
        }
    }

    public void isNotEmpty(Collection<?> collection) {
        this.isNotEmpty(collection, "\u53c2\u6570collection\u4e0d\u80fd\u4e3anull\u4e14\u957f\u5ea6\u4e0d\u80fd\u4e3a0");
    }

    public void isNotEmpty(Map<?, ?> map, String message) {
        if (LangUtils.isEmpty(map)) {
            this.throwException(message);
        }
    }

    public void isNotEmpty(Map<?, ?> map) {
        this.isNotEmpty(map, "\u53c2\u6570map\u4e0d\u80fd\u4e3anull\u4e14\u957f\u5ea6\u4e0d\u80fd\u4e3a0");
    }

    public void isExists(File file, String message) {
        if (!LangUtils.isExists(file)) {
            this.throwException(message);
        }
    }

    public void isExists(File file) {
        this.isExists(file, "\u53c2\u6570file\u4e0d\u80fd\u4e3anull\u4e14\u6587\u4ef6\u5fc5\u987b\u5b58\u5728");
    }

    public void isInstanceOf(Class<?> clazz, Object obj, String message) {
        this.isNotNull(clazz, "\u53c2\u6570clazz\u4e0d\u80fd\u4e3a\u7a7a");
        this.isTrue(clazz.isInstance(obj), message + "\u53c2\u6570obj '" + (obj == null ? "[null]" : obj.getClass().getName()) + "' \u5fc5\u987b\u662f\u53c2\u6570clazz '" + clazz.getName() + "' \u7684\u5b9e\u4f8b\uff01");
    }

    public void isInstanceOf(Class<?> clazz, Object obj) {
        this.isInstanceOf(clazz, obj, "");
    }

    private void throwException(String msg) {
        throw (RuntimeException)ClassUtils.newInstance(this.exception, msg);
    }
}

