/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.ClassUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static boolean isEmpty(Object array) {
        if (array == null) {
            return true;
        }
        if (array.getClass().isArray()) {
            return Array.getLength(array) == 0;
        }
        return false;
    }

    public static boolean isNotEmpty(Object array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static String toString(Object array) {
        Class<?> type;
        StringBuilder sb = new StringBuilder();
        if (array != null && (type = array.getClass()).isArray()) {
            sb.append("[");
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < Array.getLength(array); ++i) {
                result.append(Array.get(array, i)).append(",");
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            }
            sb.append(result.toString()).append("]");
        }
        return sb.toString();
    }

    @SafeVarargs
    public static <E> String toString(E ... objects) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (objects != null && objects.length > 0) {
            for (E object : objects) {
                sb.append(object.toString()).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public static <T> List<T> toList(T[] arrays) {
        if (arrays == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(Arrays.asList(arrays));
    }

    public static <T> boolean contain(T[] tSet, T target) {
        if (tSet == null || target == null) {
            return false;
        }
        for (T t : tSet) {
            if (!target.equals(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean containString(String[] strSet, String strTarget, boolean ignoreCase) {
        if (strSet == null || strTarget == null) {
            return false;
        }
        boolean result = false;
        for (String str : strSet) {
            if (ignoreCase) {
                if (!strTarget.equalsIgnoreCase(str)) continue;
                result = true;
                break;
            }
            if (!strTarget.equals(str)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static Object concat(Object arr1, Object arr2) {
        int len2;
        int len1;
        int n = len1 = arr1 != null ? Array.getLength(arr1) : -1;
        if (len1 <= 0) {
            return arr2;
        }
        int n2 = len2 = arr2 != null ? Array.getLength(arr2) : -1;
        if (len2 <= 0) {
            return arr1;
        }
        Class<?> commonComponentType = ClassUtils.parentClass(arr1.getClass().getComponentType(), arr2.getClass().getComponentType());
        Object newArray = Array.newInstance(commonComponentType, len1 + len2);
        System.arraycopy(arr1, 0, newArray, 0, len1);
        System.arraycopy(arr2, 0, newArray, len1, len2);
        return newArray;
    }

    public static <T> T[] create(Class<T> type, int length) {
        Object o = Array.newInstance(type, length);
        return (Object[])o;
    }
}

