/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.io.file;

import cn.featherfly.common.io.FileUtils;
import cn.featherfly.common.lang.WordUtils;
import java.io.File;

public class FileWrapper {
    private static final String DEFAULT_ZERO_SIZE = "0KB";
    private String storageId;
    private File file;
    private String fileName;
    private String contentType;
    private String extName;

    public FileWrapper(File file) {
        this.file = file;
    }

    public String getExtName() {
        return this.extName;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.extName = FileUtils.getFileExtName(fileName);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getSize() {
        if (this.file == null) {
            return DEFAULT_ZERO_SIZE;
        }
        return WordUtils.parseUnit(this.file.length());
    }

    public long getLength() {
        if (this.file == null) {
            return 0L;
        }
        return this.file.length();
    }

    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }
}

