/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.bean.matcher;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.matcher.BeanPropertyMatcher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanPropertyNameRegexMatcher
implements BeanPropertyMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanPropertyNameRegexMatcher.class);
    private Pattern namePattern;
    private String nameRegex;

    public BeanPropertyNameRegexMatcher(String nameRegex) {
        this(nameRegex, 2);
    }

    public BeanPropertyNameRegexMatcher(String nameRegex, int flags) {
        this.nameRegex = nameRegex;
        this.namePattern = Pattern.compile(nameRegex, flags);
    }

    @Override
    public boolean match(BeanProperty<?> beanProperty) {
        LOGGER.debug("\u5c5e\u6027{}\u5339\u914d\u6b63\u5219{}", (Object)beanProperty.getName(), (Object)this.nameRegex);
        Matcher m = this.namePattern.matcher(beanProperty.getName());
        return m.matches();
    }
}

