/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.bean;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.lang.AssertIllegalArgument;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapBeanDescriptor<T>
extends BeanDescriptor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapBeanDescriptor.class);

    protected MapBeanDescriptor(Class<T> type) {
        super(type);
        AssertIllegalArgument.isParent(Map.class, type);
    }

    @Override
    public void setProperty(T obj, String name, Object value) {
        if (obj == null) {
            return;
        }
        AssertIllegalArgument.isParent(Map.class, obj.getClass());
        Map map = (Map)obj;
        if (name.contains(".")) {
            String currentPropertyName = name.substring(0, name.indexOf("."));
            String innerPropertyName = name.substring(name.indexOf(".") + 1);
            Object propertyValue = map.get(currentPropertyName);
            if (propertyValue == null) {
                LOGGER.trace("\u7c7b{}\u7684\u5c5e\u6027[{}]\u4e3a\u7a7a\uff0c\u5c06\u5ffd\u7565\u5d4c\u5957\u7684\u8d4b\u503c", new Object[]{this.type.getName(), name});
                return;
            }
            BeanDescriptor<?> propertyDescriptor = MapBeanDescriptor.getBeanDescriptor(propertyValue.getClass());
            propertyDescriptor.setProperty(propertyValue, innerPropertyName, value);
        } else {
            map.put(name, value);
        }
    }

    @Override
    public Object getProperty(T obj, String name) {
        if (obj == null) {
            return null;
        }
        AssertIllegalArgument.isParent(Map.class, obj.getClass());
        Map map = (Map)obj;
        if (name.contains(".")) {
            String currentPropertyName = name.substring(0, name.indexOf("."));
            String innerPropertyName = name.substring(name.indexOf(".") + 1);
            Object propertyValue = map.get(currentPropertyName);
            Object result = null;
            if (propertyValue == null) {
                LOGGER.trace("\u7c7b{}\u7684\u5c5e\u6027[{}]\u4e3a\u7a7a", new Object[]{this.type.getName(), currentPropertyName});
            } else {
                BeanDescriptor<?> propertyDescriptor = MapBeanDescriptor.getBeanDescriptor(propertyValue.getClass());
                result = propertyDescriptor.getProperty(propertyValue, innerPropertyName);
            }
            return result;
        }
        return map.get(name);
    }
}

