/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.validation;

import cn.enilu.flash.core.db.DB;
import cn.enilu.flash.core.db.EntityWrapper;
import cn.enilu.flash.core.db.IDBProvider;
import cn.enilu.flash.core.db.Query;
import cn.enilu.flash.core.validation.Unique;
import com.google.common.base.Strings;
import java.util.ArrayList;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.beans.BeanUtils;

public class UniqueValidator
implements ConstraintValidator<Unique, Object> {
    private IDBProvider dbProvider;
    private String property;
    private String condition;
    private String[] conditionParameterProperties;

    public void initialize(Unique constraintAnnotation) {
        this.property = constraintAnnotation.property();
        Class<? extends IDBProvider> klass = constraintAnnotation.dbProvider();
        this.dbProvider = (IDBProvider)BeanUtils.instantiate(klass);
        this.condition = constraintAnnotation.condition();
        this.conditionParameterProperties = constraintAnnotation.conditionParameterProperties();
    }

    public boolean isValid(Object entity, ConstraintValidatorContext context) {
        Object id;
        EntityWrapper wrapper = new EntityWrapper(entity);
        Object propertyValue = wrapper.getPropertyValue(this.property);
        if (propertyValue == null || "".equals(propertyValue)) {
            return true;
        }
        DB db = this.dbProvider.get();
        Query query = db.from(wrapper.getTableName()).select("1").where(wrapper.getColumnName(this.property), propertyValue);
        if (!Strings.isNullOrEmpty((String)this.condition)) {
            ArrayList<Object> parameters = new ArrayList<Object>();
            for (String p : this.conditionParameterProperties) {
                parameters.add(wrapper.getPropertyValue(p));
            }
            query.segment(this.condition, parameters.toArray());
        }
        if ((id = wrapper.getId()) != null) {
            query.not(wrapper.getIdColumnName(), id);
        }
        if (query.isExists()) {
            context.buildConstraintViolationWithTemplate("\u5df2\u5b58\u5728").addPropertyNode(this.property).addConstraintViolation().disableDefaultConstraintViolation();
            return false;
        }
        return true;
    }
}

