/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.validation;

import cn.enilu.flash.core.validation.IP;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class IPValidator
implements ConstraintValidator<IP, CharSequence> {
    private static final Pattern IP_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)$");

    public void initialize(IP constraintAnnotation) {
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null || value.length() == 0) {
            return true;
        }
        Matcher m = IP_PATTERN.matcher(value);
        if (m.find()) {
            for (int i = 0; i < 4; ++i) {
                String s = m.group(i + 1);
                int num = Integer.parseInt(s);
                if (num <= 255) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

