/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.validation;

import cn.enilu.flash.core.validation.Confirm;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class ConfirmValidator
implements ConstraintValidator<Confirm, Object> {
    private String property;
    private String confirmProperty;

    public void initialize(Confirm constraintAnnotation) {
        this.property = constraintAnnotation.property();
        this.confirmProperty = constraintAnnotation.confirmProperty();
    }

    public boolean isValid(Object entity, ConstraintValidatorContext context) {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)entity);
        Object value = wrapper.getPropertyValue(this.property);
        Object confirmValue = wrapper.getPropertyValue(this.confirmProperty);
        if (this.isNullOrEmpty(value) && this.isNullOrEmpty(confirmValue)) {
            return true;
        }
        if (value != null && value.equals(confirmValue)) {
            return true;
        }
        context.buildConstraintViolationWithTemplate("\u4e24\u6b21\u8f93\u5165\u4e0d\u4e00\u81f4").addPropertyNode(this.confirmProperty).addConstraintViolation().disableDefaultConstraintViolation();
        return false;
    }

    private boolean isNullOrEmpty(Object obj) {
        return obj == null || "".equals(obj);
    }
}

