/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.util;

public abstract class StoppableThread
implements Runnable {
    protected volatile boolean stopped;
    protected volatile Thread thread;

    public void start() {
        if (this.thread != null) {
            throw new IllegalStateException("already started");
        }
        this.stopped = false;
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.start();
    }

    protected String getThreadName() {
        return this.getClass().getSimpleName();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void stop() {
        if (this.thread == null) {
            return;
        }
        this.stopped = true;
        while (this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.thread = null;
    }

    public boolean isAlive() {
        Thread t = this.thread;
        if (t == null) {
            return false;
        }
        return t.isAlive();
    }

    public void join(long millis) {
        try {
            this.thread.join(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

