/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailUtil {
    private static Logger logger = LoggerFactory.getLogger(MailUtil.class);
    private JavaMailSenderImpl javaMailSender;
    private VelocityEngine velocityEngine;

    public boolean send(MailBean mailBean) throws MessagingException {
        MimeMessage msg = this.createMimeMessage(mailBean);
        if (msg == null) {
            return false;
        }
        this.sendMail(msg, mailBean);
        return true;
    }

    public boolean send(String[] toMails, String subject, String content) throws MessagingException {
        MailBean mailBean = new MailBean();
        mailBean.setSubject(subject);
        mailBean.setToEmails(toMails);
        mailBean.setContent(content);
        this.send(mailBean);
        return true;
    }

    public boolean send(String[] toMails, String subject, String content, File[] attachments) throws MessagingException {
        MailBean mailBean = new MailBean();
        mailBean.setSubject(subject);
        mailBean.setToEmails(toMails);
        mailBean.setContent(content);
        mailBean.setAttachments(attachments);
        this.send(mailBean);
        return true;
    }

    public boolean send(String fromName, String[] toMails, String subject, String content, File[] attachments) throws MessagingException {
        MailBean mailBean = new MailBean();
        mailBean.setFromName(fromName);
        mailBean.setSubject(subject);
        mailBean.setToEmails(toMails);
        mailBean.setContent(content);
        mailBean.setAttachments(attachments);
        this.send(mailBean);
        return true;
    }

    private void sendMail(MimeMessage msg, MailBean mailBean) {
        this.javaMailSender.send(msg);
        logger.info("$$$ Send mail Subject: {}, TO: {}", (Object)mailBean.getSubject(), (Object)this.arrayToStr(mailBean.getToEmails()));
    }

    private String arrayToStr(String[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String str : array) {
            sb.append(str + " , ");
        }
        return sb.toString();
    }

    private MimeMessage createMimeMessage(MailBean mailBean) throws MessagingException {
        if (!this.checkMailBean(mailBean)) {
            return null;
        }
        String text = this.getMessage(mailBean);
        if (text == null) {
            logger.warn("@@@ warn mail text is null (Thread name=" + Thread.currentThread().getName() + ") @@@ " + mailBean.getSubject());
            return null;
        }
        MimeMessage msg = this.javaMailSender.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(msg, true, "UTF-8");
        try {
            messageHelper.setFrom(this.javaMailSender.getUsername(), mailBean.getFromName());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("set mail from error: ", (Throwable)e);
        }
        messageHelper.setSubject(mailBean.getSubject());
        messageHelper.setTo(mailBean.getToEmails());
        messageHelper.setText(text, true);
        for (File attachment : mailBean.getAttachments()) {
            FileSystemResource attachmentFile = new FileSystemResource(attachment);
            messageHelper.addAttachment(attachment.getName(), (InputStreamSource)attachmentFile);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMessage(MailBean mailBean) {
        if (StringUtils.isNotEmpty((String)mailBean.getContent())) {
            return mailBean.getContent();
        }
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            VelocityContext context = new VelocityContext(mailBean.getData());
            this.velocityEngine.evaluate((Context)context, (Writer)writer, "", mailBean.getTemplate());
            String string = writer.toString();
            return string;
        }
        catch (VelocityException e) {
            logger.error(" VelocityException : " + mailBean.getSubject() + "\n" + (Object)((Object)e));
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error("###StringWriter close error ... ");
                }
            }
        }
        return null;
    }

    private boolean checkMailBean(MailBean mailBean) {
        if (mailBean == null) {
            logger.warn("@@@ warn mailBean is null (Thread name=" + Thread.currentThread().getName() + ") ");
            return false;
        }
        if (mailBean.getSubject() == null) {
            logger.warn("@@@ warn mailBean.getSubject() is null (Thread name=" + Thread.currentThread().getName() + ") ");
            return false;
        }
        if (mailBean.getToEmails() == null) {
            logger.warn("@@@ warn mailBean.getToEmails() is null (Thread name=" + Thread.currentThread().getName() + ") ");
            return false;
        }
        return true;
    }

    public void setJavaMailSender(JavaMailSenderImpl javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public static class MailBean
    implements Serializable {
        private String fromName;
        private String[] toEmails;
        private String subject;
        private Map data;
        private String template;
        private File[] attachments = new File[0];
        private String content;

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public File[] getAttachments() {
            return this.attachments;
        }

        public void setAttachments(File[] attachments) {
            this.attachments = attachments;
        }

        public String getFromName() {
            return this.fromName;
        }

        public void setFromName(String fromName) {
            this.fromName = fromName;
        }

        public String[] getToEmails() {
            return this.toEmails;
        }

        public void setToEmails(String[] toEmails) {
            this.toEmails = toEmails;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public Map getData() {
            return this.data;
        }

        public void setData(Map data) {
            this.data = data;
        }

        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String template) {
            this.template = template;
        }
    }
}

