/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.IdentifyCmd;
import org.im4java.core.Operation;
import org.im4java.process.ArrayListOutputConsumer;
import org.im4java.process.OutputConsumer;

public final class ImageUtil {
    private static final Pattern IDENTIFY_INFO_PATTERN = Pattern.compile("^(\\d+)x(\\d+)\\s+(.*)$");
    public static final IdentifyInfo UNKNOWN_INFO = new IdentifyInfo("unknown", 0, 0);

    private ImageUtil() {
    }

    public static IdentifyInfo identify(String path) {
        IMOperation op = new IMOperation();
        op.format("%wx%h %m");
        op.addImage(new String[]{path});
        IdentifyCmd cmd = new IdentifyCmd();
        try {
            ArrayListOutputConsumer consumer = new ArrayListOutputConsumer();
            cmd.setOutputConsumer((OutputConsumer)consumer);
            cmd.run((Operation)op, new Object[0]);
            ArrayList output = consumer.getOutput();
            if (output.isEmpty()) {
                return UNKNOWN_INFO;
            }
            Matcher m = IDENTIFY_INFO_PATTERN.matcher((CharSequence)output.get(0));
            if (m.find()) {
                String format = m.group(3);
                int width = Integer.parseInt(m.group(1));
                int height = Integer.parseInt(m.group(2));
                return new IdentifyInfo(format, width, height);
            }
            return UNKNOWN_INFO;
        }
        catch (Exception e) {
            throw new ImageIdentifyException("run identify failed", e);
        }
    }

    public static void resize(String from, String to, int width, int height) {
        IMOperation op = new IMOperation();
        op.addImage(new String[]{from});
        op.resize(Integer.valueOf(width), Integer.valueOf(height));
        op.addImage(new String[]{to});
        ImageUtil.runConvert(op);
    }

    public static void resizeWithWhitePadding(String from, String to, int width, int height) {
        ImageUtil.resize(from, to, width, height, "#FFFFFF", false);
    }

    public static void resize(String from, String to, int width, int height, String paddingColor) {
        ImageUtil.resize(from, to, width, height, paddingColor, false);
    }

    public static void resize(String from, String to, int width, int height, String paddingColor, boolean transparent) {
        IMOperation op = new IMOperation();
        op.size(Integer.valueOf(width), Integer.valueOf(height)).addImage(new String[]{"xc:" + paddingColor});
        op.addImage(new String[]{from});
        op.resize(Integer.valueOf(width), Integer.valueOf(height));
        op.gravity("center");
        if (transparent) {
            op.transparent(paddingColor);
        }
        op.composite();
        op.addImage(new String[]{to});
        ImageUtil.runConvert(op);
    }

    public static void crop(String from, String to, int x, int y, int width, int height) {
        IMOperation op = new IMOperation();
        op.addImage(new String[]{from});
        op.crop(Integer.valueOf(width), Integer.valueOf(height), Integer.valueOf(x), Integer.valueOf(y));
        op.addImage(new String[]{to});
        ImageUtil.runConvert(op);
    }

    public static void crop(String from, String to, int x, int y, int width, int height, int resizeWidth, int resizeHeight) {
        IMOperation op = new IMOperation();
        op.addImage(new String[]{from});
        op.crop(Integer.valueOf(width), Integer.valueOf(height), Integer.valueOf(x), Integer.valueOf(y));
        op.resize(Integer.valueOf(resizeWidth), Integer.valueOf(resizeHeight));
        op.addImage(new String[]{to});
        ImageUtil.runConvert(op);
    }

    private static void runConvert(IMOperation op) {
        ConvertCmd convert = new ConvertCmd();
        try {
            convert.run((Operation)op, new Object[0]);
        }
        catch (Exception e) {
            throw new ImageConvertException("convert failed, op=" + op.toString(), e);
        }
    }

    public static void main(String[] args) {
        String from = "cctv1.jpg";
        from = "/Users/wangyong/Documents/image/3.png";
        IdentifyInfo info = ImageUtil.identify(from);
        System.out.println(info.getWidth());
    }

    public static class IdentifyInfo {
        private final String format;
        private final int width;
        private final int height;

        public IdentifyInfo(String format, int width, int height) {
            this.format = format;
            this.width = width;
            this.height = height;
        }

        public String getFormat() {
            return this.format;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public String toString() {
            return "IdentifyInfo{format='" + this.format + '\'' + ", width=" + this.width + ", height=" + this.height + '}';
        }
    }

    public static class ImageIdentifyException
    extends RuntimeException {
        public ImageIdentifyException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ImageConvertException
    extends RuntimeException {
        public ImageConvertException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

