/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.util;

import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateTimeUtil {
    private DateTimeUtil() {
    }

    public static String format(DateTime dt, String pattern) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern);
        return formatter.print((ReadableInstant)dt);
    }

    public static DateTime parse(String date, String pattern) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)pattern);
        return formatter.parseDateTime(date);
    }

    public static String formatDate(DateTime dt) {
        return DateTimeUtil.format(dt, "yyyy-MM-dd");
    }

    public static DateTime parseDate(String date) {
        return DateTimeUtil.parse(date, "yyyy-MM-dd");
    }

    public static String formatCompactDate(DateTime dt) {
        return DateTimeUtil.format(dt, "yyyyMMdd");
    }

    public static DateTime parseCompactDate(String date) {
        return DateTimeUtil.parse(date, "yyyyMMdd");
    }

    public static String formatTime(DateTime dt) {
        return DateTimeUtil.format(dt, "HH:mm:ss");
    }

    public static String formatCompactTime(DateTime dt) {
        return DateTimeUtil.format(dt, "HHmmss");
    }

    public static String formatDateTime(DateTime dt) {
        return DateTimeUtil.format(dt, "yyyy-MM-dd HH:mm:ss");
    }

    public static DateTime parseDateTime(String date) {
        return DateTimeUtil.parse(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatCompactDateTime(DateTime dt) {
        return DateTimeUtil.format(dt, "yyyyMMddHHmmss");
    }

    public static DateTime parseCompactDateTime(String date) {
        return DateTimeUtil.parse(date, "yyyyMMddHHmmss");
    }

    public static String formatHumanReadable(Date date) {
        if (date == null) {
            return "";
        }
        return DateTimeUtil.formatHumanReadable(new DateTime((Object)date));
    }

    public static String formatHumanReadable(DateTime date) {
        if (date == null) {
            return "";
        }
        long currentDate = System.currentTimeMillis();
        long createDate = date.getMillis();
        long sub = currentDate - createDate;
        String val = "\u521a\u521a";
        if ((sub /= 1000L) > 0L) {
            val = sub < 60L ? sub + "\u79d2\u524d" : (sub >= 60L && sub < 3600L ? sub / 60L + "\u5206\u949f\u524d" : (sub >= 3600L && sub < 86400L ? sub / 3600L + "\u5c0f\u65f6\u524d" : (sub >= 86400L && sub < 31536000L ? sub / 86400L + "\u5929\u524d" : "1\u5e74\u524d")));
        }
        return val;
    }
}

