/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.util;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandExecutor {
    private File workDir;
    private Map<String, String> envp = new HashMap<String, String>();
    private final String cmd;
    private final List<String> args = new ArrayList<String>();
    private InputStream stdin;
    private List<String> stdOutput = new ArrayList<String>();
    private List<String> errorOutput = new ArrayList<String>();
    private int exitCode;

    public CommandExecutor(String cmd, String ... args) {
        this.cmd = cmd;
        this.args.addAll(Arrays.asList(args));
    }

    public void setArgs(List<String> args) {
        this.args.clear();
        this.args.addAll(args);
    }

    public void setArgs(String ... args) {
        this.setArgs(Arrays.asList(args));
    }

    public void addArg(String arg) {
        this.args.add(arg);
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void setStdin(InputStream in) {
        this.stdin = in;
    }

    public void setStdin(String in) {
        this.stdin = new ByteArrayInputStream(in.getBytes());
    }

    public void setStdin(byte[] in) {
        this.stdin = new ByteArrayInputStream(in);
    }

    public void setEnv(String name, String value) {
        this.envp.put(name, value);
    }

    public boolean safeExecute() {
        try {
            return this.execute();
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean execute() throws IOException {
        ArrayList command = Lists.newArrayList();
        command.add(this.cmd);
        command.addAll(this.args);
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(this.workDir);
        builder.environment().putAll(this.envp);
        Process process = builder.start();
        if (this.stdin != null) {
            this.pipeline(this.stdin, process.getOutputStream());
        }
        InputStream std = process.getInputStream();
        InputStream error = process.getErrorStream();
        this.stdOutput = this.toLines(std);
        this.errorOutput = this.toLines(error);
        if (std != null) {
            std.close();
        }
        if (error != null) {
            error.close();
        }
        while (true) {
            try {
                this.exitCode = process.waitFor();
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
        return this.exitCode == 0;
    }

    private void pipeline(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        in.close();
        out.flush();
        out.close();
    }

    private List<String> toLines(InputStream in) throws IOException {
        InputStreamReader inUTF8 = new InputStreamReader(in, Charsets.UTF_8);
        List result = CharStreams.readLines((Readable)inUTF8);
        inUTF8.close();
        return result;
    }

    public List<String> getStdOutput() {
        return this.stdOutput;
    }

    public List<String> getErrorOutput() {
        return this.errorOutput;
    }
}

