/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.service;

import cn.enilu.flash.core.db.DB;
import javax.inject.Inject;
import org.springframework.transaction.annotation.Transactional;

public abstract class EntityService<T, P> {
    protected final Class<T> klass;
    @Inject
    protected DB db;

    public EntityService(Class<T> klass) {
        this.klass = klass;
    }

    public T find(P id) {
        T entity = this.db.find(this.klass, id);
        this.afterFind(entity);
        return entity;
    }

    protected void afterFind(T entity) {
    }

    @Transactional
    public void create(T entity) {
        this.beforeCreate(entity);
        this.db.insert(entity);
        this.afterCreate(entity);
    }

    protected void beforeCreate(T entity) {
    }

    protected void afterCreate(T entity) {
    }

    @Transactional
    public void update(T entity) {
        this.beforeUpdate(entity);
        this.db.update(entity);
        this.afterUpdate(entity);
    }

    protected void beforeUpdate(T entity) {
    }

    protected void afterUpdate(T entity) {
    }

    @Transactional
    public T delete(P id) {
        T entity = this.find(id);
        return this.destroy(entity);
    }

    @Transactional
    public T destroy(T entity) {
        this.beforeDestroy(entity);
        this.db.delete(entity);
        this.afterDestroy(entity);
        return entity;
    }

    protected void beforeDestroy(T entity) {
    }

    protected void afterDestroy(T entity) {
    }
}

