/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.lang;

import cn.enilu.flash.core.lang.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public final class Reflects {
    private Reflects() {
    }

    public static List<Field> getFields(Class<?> klass, boolean recursive) {
        return Reflects.getFields(klass, null, recursive);
    }

    public static List<Field> getFields(Class<?> klass, Class<? extends Annotation> annotationClass, boolean recursive) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        ArrayList classList = Lists.newArrayList();
        classList.add(klass);
        if (recursive) {
            for (Class<?> current = klass.getSuperclass(); current != null; current = current.getSuperclass()) {
                classList.add(current);
            }
        }
        for (int i = classList.size() - 1; i >= 0; --i) {
            Class current = (Class)classList.get(i);
            for (Field field : current.getDeclaredFields()) {
                if (annotationClass == null) {
                    fields.put(field.getName(), field);
                    continue;
                }
                if (field.getAnnotation(annotationClass) == null) continue;
                fields.put(field.getName(), field);
            }
        }
        return new ArrayList<Field>(fields.values());
    }

    public static boolean isAnnotationPresent(Class<?> klass, Class<? extends Annotation> annotationClass) {
        for (Class<?> current = klass; current != null; current = current.getSuperclass()) {
            if (!current.isAnnotationPresent(annotationClass)) continue;
            return true;
        }
        return false;
    }

    public static <A extends Annotation> ClassAnnotation<A> getAnnotation(Class<?> klass, Class<A> annotationClass) {
        for (Class<?> current = klass; current != null; current = current.getSuperclass()) {
            if (!current.isAnnotationPresent(annotationClass)) continue;
            A annotation = current.getAnnotation(annotationClass);
            return new ClassAnnotation<A>(current, annotation);
        }
        return null;
    }

    public static Field getField(Class<?> cc, String name) {
        while (null != cc && cc != Object.class) {
            try {
                return cc.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                cc = cc.getSuperclass();
            }
        }
        return null;
    }

    public static Class getParameterizedType(Field field) {
        Type type = field.getGenericType();
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Class genericClazz = (Class)pt.getActualTypeArguments()[0];
            return genericClazz;
        }
        return null;
    }

    public static class ClassAnnotation<A extends Annotation> {
        private final Class<?> klass;
        private final A annotation;

        public ClassAnnotation(Class<?> klass, A annotation) {
            this.klass = klass;
            this.annotation = annotation;
        }

        public Class<?> getKlass() {
            return this.klass;
        }

        public A getAnnotation() {
            return this.annotation;
        }
    }
}

