/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.lang;

import cn.enilu.flash.core.lang.Beans;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;

public final class Lists {
    private Lists() {
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> List<T> fill(Class<T> klass, int count) {
        ArrayList<T> result = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            result.add(BeanUtils.instantiate(klass));
        }
        return result;
    }

    public static <T> List<T> flatten(List<?> list) {
        ArrayList<T> result = Lists.newArrayList();
        for (Object o : list) {
            if (o instanceof List) {
                List<T> subResult = Lists.flatten((List)o);
                result.addAll(subResult);
                continue;
            }
            result.add(o);
        }
        return result;
    }

    public static <T> List<T> compact(List<T> list) {
        ArrayList<T> result = Lists.newArrayList();
        for (T t : list) {
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    public static <T, R> List<R> map(List<T> list, String property) {
        ArrayList<T> result = Lists.newArrayList();
        for (T t : list) {
            Object r = Beans.get(t, property);
            result.add(r);
        }
        return result;
    }

    public static <K, V> Map<K, V> toMap(List<V> list, String keyProperty) {
        HashMap map = new HashMap();
        for (V v : list) {
            Object k = Beans.get(v, keyProperty);
            map.put(k, v);
        }
        return map;
    }

    public static <T> List<T> filter(List<T> list, String property, Object value) {
        ArrayList<T> result = Lists.newArrayList();
        for (T t : list) {
            Object v = Beans.get(t, property);
            if ((v != null || value != null) && (v == null || !v.equals(value))) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> without(List<T> list, T value) {
        ArrayList<T> result = Lists.newArrayList();
        for (T t : list) {
            if (value == null && t == null || value != null && value.equals(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> uniq(List<T> input) {
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>();
        for (T t : input) {
            map.put(t, t);
        }
        return new ArrayList(map.values());
    }

    public static <K, T> List<T> sortBy(List<T> input, String keyProperty, List<K> keys) {
        if (input.isEmpty()) {
            return Lists.newArrayList();
        }
        Map<K, T> map = Lists.toMap(input, keyProperty);
        ArrayList<T> result = Lists.newArrayList();
        for (K k : keys) {
            T t = map.get(k);
            if (t == null) continue;
            result.add(t);
        }
        return result;
    }

    public static <K, V> Map<K, List<V>> group(List<V> input, String keyProperty) {
        HashMap result = new HashMap();
        for (V v : input) {
            Object k = Beans.get(v, keyProperty);
            ArrayList<V> list = (ArrayList<V>)result.get(k);
            if (list == null) {
                list = new ArrayList<V>();
                result.put(k, list);
            }
            list.add(v);
        }
        return result;
    }

    public static <T> List<List<T>> group(List<T> input, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must > 0");
        }
        int size = input.size();
        int m = (size + n - 1) / n;
        ArrayList<List<T>> result = new ArrayList<List<T>>(m);
        for (int i = 0; i < m; ++i) {
            ArrayList<T> items = new ArrayList<T>(n);
            int end = i < m - 1 ? n : size - i * n;
            for (int j = 0; j < end; ++j) {
                items.add(input.get(i * n + j));
            }
            result.add(items);
        }
        return result;
    }

    public static boolean containAny(Set parent, Set child) {
        if (parent == null || child == null) {
            return false;
        }
        Iterator iter = child.iterator();
        if (iter.hasNext()) {
            return parent.contains(iter.next());
        }
        return false;
    }
}

