/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.lang;

import java.beans.PropertyDescriptor;
import java.util.Arrays;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public final class Beans {
    private Beans() {
    }

    public static void set(Object bean, String property, Object value) {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        wrapper.setPropertyValue(property, value);
    }

    public static <R> R get(Object bean, String property) {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        return (R)wrapper.getPropertyValue(property);
    }

    public static <T, R> R copy(T from, Class<R> klass, String ... excludedProperties) {
        Object to = BeanUtils.instantiate(klass);
        return (R)Beans.copy(from, to, excludedProperties);
    }

    public static <T, R> R copy(T from, R to, String ... excludedProperties) {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess(from);
        BeanWrapper toWrapper = PropertyAccessorFactory.forBeanPropertyAccess(to);
        Arrays.sort(excludedProperties);
        for (PropertyDescriptor descriptor : wrapper.getPropertyDescriptors()) {
            boolean found;
            if (descriptor.getWriteMethod() == null || descriptor.getReadMethod() == null) continue;
            String name = descriptor.getName();
            boolean bl = found = Arrays.binarySearch(excludedProperties, name) >= 0;
            if (found) continue;
            toWrapper.setPropertyValue(name, wrapper.getPropertyValue(name));
        }
        return to;
    }

    public static <T, R> T extend(T target, R source, String ... includedProperties) {
        return Beans.extend(target, source, false, includedProperties);
    }

    public static <T, R> T extend(T target, R source, boolean ignoreNullProperty, String ... includedProperties) {
        BeanWrapper targetWrapper = PropertyAccessorFactory.forBeanPropertyAccess(target);
        BeanWrapper sourceWrapper = PropertyAccessorFactory.forBeanPropertyAccess(source);
        Arrays.sort(includedProperties);
        for (PropertyDescriptor descriptor : sourceWrapper.getPropertyDescriptors()) {
            boolean found;
            if (descriptor.getWriteMethod() == null || descriptor.getReadMethod() == null) continue;
            String name = descriptor.getName();
            boolean bl = found = includedProperties.length == 0 || Arrays.binarySearch(includedProperties, name) >= 0;
            if (!found || ignoreNullProperty && sourceWrapper.getPropertyValue(name) == null || !targetWrapper.isWritableProperty(name)) continue;
            targetWrapper.setPropertyValue(name, sourceWrapper.getPropertyValue(name));
        }
        return target;
    }
}

